/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.HttpProbeCreator;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.util.StringUtils;

class ReadinessHttpProbeCreator
extends HttpProbeCreator {
    ReadinessHttpProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    @Override
    public Integer getPort() {
        String probePortValue = this.getProbeProperty("spring.cloud.deployer.kubernetes.readiness", "Http", "ProbePort");
        if (StringUtils.hasText((String)probePortValue)) {
            if (!probePortValue.chars().allMatch(Character::isDigit)) {
                throw new IllegalArgumentException("ReadinessHttpProbeCreator must contain all digits");
            }
            return Integer.parseInt(probePortValue);
        }
        if (this.getKubernetesDeployerProperties().getReadinessHttpProbePort() != null) {
            return this.getKubernetesDeployerProperties().getReadinessHttpProbePort();
        }
        if (this.getDefaultPort() != null) {
            return this.getDefaultPort();
        }
        return null;
    }

    @Override
    protected String getProbePath() {
        String probePathValue = this.getProbeProperty("spring.cloud.deployer.kubernetes.readiness", "Http", "ProbePath");
        if (StringUtils.hasText((String)probePathValue)) {
            return probePathValue;
        }
        if (this.getKubernetesDeployerProperties().getReadinessHttpProbePath() != null) {
            return this.getKubernetesDeployerProperties().getReadinessHttpProbePath();
        }
        if (this.useBoot1ProbePath()) {
            return "/info";
        }
        return "/actuator/info";
    }

    @Override
    protected String getScheme() {
        String probeSchemeValue = this.getProbeProperty("spring.cloud.deployer.kubernetes.readiness", "Http", "ProbeScheme");
        if (StringUtils.hasText((String)probeSchemeValue)) {
            return probeSchemeValue;
        }
        if (this.getKubernetesDeployerProperties().getReadinessHttpProbeScheme() != null) {
            return this.getKubernetesDeployerProperties().getReadinessHttpProbeScheme();
        }
        return "HTTP";
    }

    @Override
    protected int getTimeout() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.readiness", "Http", "ProbeTimeout", this.getKubernetesDeployerProperties().getReadinessHttpProbeTimeout());
    }

    @Override
    protected int getInitialDelay() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.readiness", "Http", "ProbeDelay", this.getKubernetesDeployerProperties().getReadinessHttpProbeDelay());
    }

    @Override
    protected int getPeriod() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.readiness", "Http", "ProbePeriod", this.getKubernetesDeployerProperties().getReadinessHttpProbePeriod());
    }

    @Override
    int getFailure() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.readiness", "Http", "ProbeFailure", this.getKubernetesDeployerProperties().getReadinessHttpProbeFailure());
    }

    @Override
    int getSuccess() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.readiness", "Http", "ProbeSuccess", this.getKubernetesDeployerProperties().getReadinessHttpProbeSuccess());
    }
}

