/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.CommandProbeCreator;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.util.CommandLineTokenizer;
import org.springframework.util.StringUtils;

class LivenessCommandProbeCreator
extends CommandProbeCreator {
    LivenessCommandProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    @Override
    int getInitialDelay() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.liveness", "Command", "ProbeDelay", this.getKubernetesDeployerProperties().getLivenessCommandProbeDelay());
    }

    @Override
    int getPeriod() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.liveness", "Command", "ProbePeriod", this.getKubernetesDeployerProperties().getLivenessCommandProbePeriod());
    }

    @Override
    int getFailure() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.liveness", "Command", "ProbeFailure", this.getKubernetesDeployerProperties().getLivenessCommandProbeFailure());
    }

    @Override
    int getSuccess() {
        return this.getProbeIntProperty("spring.cloud.deployer.kubernetes.liveness", "Command", "ProbeSuccess", this.getKubernetesDeployerProperties().getLivenessCommandProbeSuccess());
    }

    @Override
    String[] getCommand() {
        String probeCommandValue = this.getDeploymentPropertyValue("spring.cloud.deployer.kubernetes.livenessCommandProbeCommand");
        if (StringUtils.hasText((String)probeCommandValue)) {
            return new CommandLineTokenizer(probeCommandValue).getArgs().toArray(new String[0]);
        }
        if (this.getKubernetesDeployerProperties().getLivenessCommandProbeCommand() != null) {
            return new CommandLineTokenizer(this.getKubernetesDeployerProperties().getLivenessCommandProbeCommand()).getArgs().toArray(new String[0]);
        }
        throw new IllegalArgumentException("The livenessCommandProbeCommand property must be set.");
    }
}

