/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.Probe;
import java.util.Map;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.support.PropertyParserUtils;

abstract class ProbeCreator {
    static final String KUBERNETES_DEPLOYER_PREFIX = "spring.cloud.deployer.kubernetes";
    static final String LIVENESS_DEPLOYER_PROPERTY_PREFIX = "spring.cloud.deployer.kubernetes.liveness";
    static final String READINESS_DEPLOYER_PROPERTY_PREFIX = "spring.cloud.deployer.kubernetes.readiness";
    private ContainerConfiguration containerConfiguration;
    private KubernetesDeployerProperties kubernetesDeployerProperties;

    ProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
        this.kubernetesDeployerProperties = kubernetesDeployerProperties;
    }

    abstract Probe create();

    abstract int getInitialDelay();

    abstract int getPeriod();

    KubernetesDeployerProperties getKubernetesDeployerProperties() {
        return this.kubernetesDeployerProperties;
    }

    private Map<String, String> getDeploymentProperties() {
        return this.containerConfiguration.getAppDeploymentRequest().getDeploymentProperties();
    }

    String getDeploymentPropertyValue(String propertyName) {
        return PropertyParserUtils.getDeploymentPropertyValue(this.getDeploymentProperties(), propertyName);
    }

    ContainerConfiguration getContainerConfiguration() {
        return this.containerConfiguration;
    }
}

