/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvFromSource;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarSource;
import io.fabric8.kubernetes.api.model.ObjectFieldSelector;
import io.fabric8.kubernetes.api.model.Probe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.DeploymentPropertiesResolver;
import org.springframework.cloud.deployer.spi.kubernetes.EntryPointStyle;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.ProbeCreatorFactory;
import org.springframework.cloud.deployer.spi.kubernetes.ProbeType;
import org.springframework.cloud.deployer.spi.scheduler.ScheduleRequest;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultContainerFactory
implements ContainerFactory {
    private static Log logger = LogFactory.getLog(DefaultContainerFactory.class);
    private static final String SPRING_APPLICATION_JSON = "SPRING_APPLICATION_JSON";
    private static final String SPRING_CLOUD_APPLICATION_GUID = "SPRING_CLOUD_APPLICATION_GUID";
    private final KubernetesDeployerProperties properties;

    public DefaultContainerFactory(KubernetesDeployerProperties properties) {
        this.properties = properties;
    }

    @Override
    public Container create(ContainerConfiguration containerConfiguration) {
        List<String> containerCommand;
        String image;
        AppDeploymentRequest request = containerConfiguration.getAppDeploymentRequest();
        Map<String, String> deploymentProperties = this.getDeploymentProperties(request);
        DeploymentPropertiesResolver deploymentPropertiesResolver = this.getDeploymentPropertiesResolver(request);
        try {
            image = request.getResource().getURI().getSchemeSpecificPart();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to get URI for " + request.getResource(), e);
        }
        logger.info((Object)("Using Docker image: " + image));
        EntryPointStyle entryPointStyle = deploymentPropertiesResolver.determineEntryPointStyle(deploymentProperties);
        logger.info((Object)("Using Docker entry point style: " + (Object)((Object)entryPointStyle)));
        HashMap<String, String> envVarsMap = new HashMap<String, String>();
        for (String envVar : this.properties.getEnvironmentVariables()) {
            String[] strings = envVar.split("=", 2);
            Assert.isTrue((strings.length == 2 ? 1 : 0) != 0, (String)("Invalid environment variable declared: " + envVar));
            envVarsMap.put(strings[0], strings[1]);
        }
        envVarsMap.putAll(deploymentPropertiesResolver.getAppEnvironmentVariables(deploymentProperties));
        List<Object> appArgs = new ArrayList();
        switch (entryPointStyle) {
            case exec: {
                appArgs = this.createCommandArgs(request);
                break;
            }
            case boot: {
                if (envVarsMap.containsKey(SPRING_APPLICATION_JSON)) {
                    throw new IllegalStateException("You can't use boot entry point style and also set SPRING_APPLICATION_JSON for the app");
                }
                try {
                    envVarsMap.put(SPRING_APPLICATION_JSON, new ObjectMapper().writeValueAsString((Object)request.getDefinition().getProperties()));
                }
                catch (JsonProcessingException e) {
                    throw new IllegalStateException("Unable to create SPRING_APPLICATION_JSON", e);
                }
                appArgs = request.getCommandlineArguments();
                break;
            }
            case shell: {
                for (String key : request.getDefinition().getProperties().keySet()) {
                    String envVar;
                    envVar = key.replace('.', '_').toUpperCase();
                    envVarsMap.put(envVar, (String)request.getDefinition().getProperties().get(key));
                }
                for (String cmdLineArg : request.getCommandlineArguments()) {
                    String cmdLineArgKey = cmdLineArg.startsWith("--") ? cmdLineArg.substring(2, cmdLineArg.indexOf("=")) : cmdLineArg.substring(0, cmdLineArg.indexOf("="));
                    String cmdLineArgValue = cmdLineArg.substring(cmdLineArg.indexOf("=") + 1);
                    envVarsMap.put(cmdLineArgKey.replace('.', '_').toUpperCase(), cmdLineArgValue);
                }
                break;
            }
        }
        ArrayList<EnvVar> envVars = new ArrayList<EnvVar>();
        for (Map.Entry e : envVarsMap.entrySet()) {
            envVars.add(new EnvVar((String)e.getKey(), (String)e.getValue(), null));
        }
        envVars.addAll(deploymentPropertiesResolver.getSecretKeyRefs(deploymentProperties));
        envVars.addAll(deploymentPropertiesResolver.getConfigMapKeyRefs(deploymentProperties));
        envVars.add(this.getGUIDEnvVar());
        if (request.getDeploymentProperties().get("spring.cloud.deployer.group") != null) {
            envVars.add(new EnvVar("SPRING_CLOUD_APPLICATION_GROUP", (String)request.getDeploymentProperties().get("spring.cloud.deployer.group"), null));
        }
        ArrayList<EnvFromSource> envFromSources = new ArrayList<EnvFromSource>();
        envFromSources.addAll(deploymentPropertiesResolver.getConfigMapRefs(deploymentProperties));
        envFromSources.addAll(deploymentPropertiesResolver.getSecretRefs(deploymentProperties));
        ContainerBuilder container = new ContainerBuilder();
        ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)container.withName(containerConfiguration.getAppId())).withImage(image)).withEnv(envVars)).withEnvFrom(envFromSources)).withArgs(appArgs)).withVolumeMounts(deploymentPropertiesResolver.getVolumeMounts(deploymentProperties));
        HashSet<Integer> ports = new HashSet<Integer>();
        Integer defaultPort = containerConfiguration.getExternalPort();
        if (defaultPort != null) {
            ports.add(defaultPort);
        }
        ports.addAll(deploymentPropertiesResolver.getContainerPorts(deploymentProperties));
        this.configureReadinessProbe(containerConfiguration, container, ports);
        this.configureLivenessProbe(containerConfiguration, container, ports);
        if (!ports.isEmpty()) {
            for (Integer containerPort : ports) {
                if (containerConfiguration.isHostNetwork()) {
                    ((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)container.addNewPort().withContainerPort(containerPort)).withHostPort(containerPort)).endPort();
                    continue;
                }
                ((ContainerFluent.PortsNested)container.addNewPort().withContainerPort(containerPort)).endPort();
            }
        }
        if (!(containerCommand = deploymentPropertiesResolver.getContainerCommand(deploymentProperties)).isEmpty()) {
            container.withCommand(containerCommand);
        }
        return container.build();
    }

    private EnvVar getGUIDEnvVar() {
        ObjectFieldSelector objectFieldSelector = new ObjectFieldSelector();
        objectFieldSelector.setFieldPath("metadata.uid");
        EnvVarSource envVarSource = new EnvVarSource();
        envVarSource.setFieldRef(objectFieldSelector);
        EnvVar guidEnvVar = new EnvVar();
        guidEnvVar.setValueFrom(envVarSource);
        guidEnvVar.setName(SPRING_CLOUD_APPLICATION_GUID);
        return guidEnvVar;
    }

    private void configureReadinessProbe(ContainerConfiguration containerConfiguration, ContainerBuilder containerBuilder, Set<Integer> ports) {
        Probe readinessProbe = ProbeCreatorFactory.createReadinessProbe(containerConfiguration, this.properties, this.getProbeType(containerConfiguration));
        Integer probePort = null;
        if (readinessProbe.getHttpGet() != null) {
            probePort = readinessProbe.getHttpGet().getPort().getIntVal();
        }
        if (readinessProbe.getTcpSocket() != null) {
            probePort = readinessProbe.getTcpSocket().getPort().getIntVal();
        }
        if (probePort != null || containerConfiguration.getExternalPort() != null && readinessProbe.getExec() != null) {
            containerBuilder.withReadinessProbe(readinessProbe);
        }
        if (probePort != null) {
            ports.add(probePort);
        }
    }

    private void configureLivenessProbe(ContainerConfiguration containerConfiguration, ContainerBuilder containerBuilder, Set<Integer> ports) {
        Probe livenessProbe = ProbeCreatorFactory.createLivenessProbe(containerConfiguration, this.properties, this.getProbeType(containerConfiguration));
        Integer probePort = null;
        if (livenessProbe.getHttpGet() != null) {
            probePort = livenessProbe.getHttpGet().getPort().getIntVal();
        }
        if (livenessProbe.getTcpSocket() != null) {
            probePort = livenessProbe.getTcpSocket().getPort().getIntVal();
        }
        if (probePort != null || containerConfiguration.getExternalPort() != null && livenessProbe.getExec() != null) {
            containerBuilder.withLivenessProbe(livenessProbe);
        }
        if (probePort != null) {
            ports.add(probePort);
        }
    }

    private ProbeType getProbeType(ContainerConfiguration containerConfiguration) {
        AppDeploymentRequest appDeploymentRequest = containerConfiguration.getAppDeploymentRequest();
        Map<String, String> deploymentProperties = this.getDeploymentProperties(appDeploymentRequest);
        DeploymentPropertiesResolver deploymentPropertiesResolver = this.getDeploymentPropertiesResolver(appDeploymentRequest);
        return deploymentPropertiesResolver.determineProbeType(deploymentProperties);
    }

    List<String> createCommandArgs(AppDeploymentRequest request) {
        LinkedList<String> cmdArgs = new LinkedList<String>();
        List commandArgOptions = request.getCommandlineArguments().stream().map(arg -> arg.substring(0, arg.indexOf("=")).replaceAll("^--", "")).collect(Collectors.toList());
        Map args = request.getDefinition().getProperties();
        for (Map.Entry entry : args.entrySet()) {
            if (!StringUtils.hasText((String)((String)entry.getValue()))) {
                logger.warn((Object)("Excluding request property with missing value from command args: " + (String)entry.getKey()));
                continue;
            }
            if (commandArgOptions.contains(entry.getKey())) {
                logger.warn((Object)String.format("Excluding request property [--%s=%s] as a command arg. Existing command line argument takes precedence.", entry.getKey(), entry.getValue()));
                continue;
            }
            cmdArgs.add(String.format("--%s=%s", entry.getKey(), entry.getValue()));
        }
        cmdArgs.addAll(request.getCommandlineArguments());
        logger.debug((Object)("Using command args: " + cmdArgs));
        return cmdArgs;
    }

    private DeploymentPropertiesResolver getDeploymentPropertiesResolver(AppDeploymentRequest request) {
        String propertiesPrefix = request instanceof ScheduleRequest && ((ScheduleRequest)request).getSchedulerProperties() != null && ((ScheduleRequest)request).getSchedulerProperties().size() > 0 ? "spring.cloud.scheduler.kubernetes" : "spring.cloud.deployer.kubernetes";
        return new DeploymentPropertiesResolver(propertiesPrefix, this.properties);
    }

    private Map<String, String> getDeploymentProperties(AppDeploymentRequest request) {
        return request.getDeploymentProperties();
    }
}

