/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.batch.DoneableJob;
import io.fabric8.kubernetes.api.model.batch.Job;
import io.fabric8.kubernetes.api.model.batch.JobFluent;
import io.fabric8.kubernetes.api.model.batch.JobList;
import io.fabric8.kubernetes.api.model.batch.JobSpec;
import io.fabric8.kubernetes.api.model.batch.JobSpecBuilder;
import io.fabric8.kubernetes.api.model.batch.JobStatus;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.hashids.Hashids;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.kubernetes.AbstractKubernetesDeployer;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.DefaultContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.DeploymentPropertiesResolver;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesTaskLauncherProperties;
import org.springframework.cloud.deployer.spi.kubernetes.RestartPolicy;
import org.springframework.cloud.deployer.spi.kubernetes.support.PropertyParserUtils;
import org.springframework.cloud.deployer.spi.task.LaunchState;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.deployer.spi.task.TaskStatus;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class KubernetesTaskLauncher
extends AbstractKubernetesDeployer
implements TaskLauncher {
    private KubernetesTaskLauncherProperties taskLauncherProperties;

    @Autowired
    public KubernetesTaskLauncher(KubernetesDeployerProperties properties, KubernetesClient client) {
        this(properties, new KubernetesTaskLauncherProperties(), client, new DefaultContainerFactory(properties));
    }

    @Autowired
    public KubernetesTaskLauncher(KubernetesDeployerProperties properties, KubernetesClient client, ContainerFactory containerFactory) {
        this(properties, new KubernetesTaskLauncherProperties(), client, containerFactory);
    }

    @Autowired
    public KubernetesTaskLauncher(KubernetesDeployerProperties deployerProperties, KubernetesTaskLauncherProperties taskLauncherProperties, KubernetesClient client) {
        this(deployerProperties, taskLauncherProperties, client, new DefaultContainerFactory(deployerProperties));
    }

    @Autowired
    public KubernetesTaskLauncher(KubernetesDeployerProperties kubernetesDeployerProperties, KubernetesTaskLauncherProperties taskLauncherProperties, KubernetesClient client, ContainerFactory containerFactory) {
        this.properties = kubernetesDeployerProperties;
        this.taskLauncherProperties = taskLauncherProperties;
        this.client = client;
        this.containerFactory = containerFactory;
        this.deploymentPropertiesResolver = new DeploymentPropertiesResolver("spring.cloud.deployer.kubernetes", this.properties);
    }

    public String launch(AppDeploymentRequest request) {
        String appId = this.createDeploymentId(request);
        TaskStatus status = this.status(appId);
        if (!status.getState().equals((Object)LaunchState.unknown)) {
            throw new IllegalStateException("Task " + appId + " already exists with a state of " + status);
        }
        if (this.maxConcurrentExecutionsReached()) {
            throw new IllegalStateException(String.format("Cannot launch task %s. The maximum concurrent task executions is at its limit [%d].", request.getDefinition().getName(), this.getMaximumConcurrentTasks()));
        }
        this.logPossibleDownloadResourceMessage(request.getResource());
        try {
            this.launch(appId, request);
            return appId;
        }
        catch (RuntimeException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void cancel(String id) {
        this.logger.debug((Object)String.format("Cancelling task: %s", id));
        this.cleanup(id);
    }

    public void cleanup(String id) {
        try {
            if (this.properties.isCreateJob()) {
                this.deleteJob(id);
            } else {
                this.deletePod(id);
            }
        }
        catch (RuntimeException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void destroy(String appName) {
        for (String id : this.getIdsForTasks(Optional.of(appName), this.properties.isCreateJob())) {
            this.cleanup(id);
        }
    }

    public RuntimeEnvironmentInfo environmentInfo() {
        return super.createRuntimeEnvironmentInfo(TaskLauncher.class, this.getClass());
    }

    public TaskStatus status(String id) {
        TaskStatus status = this.buildTaskStatus(id);
        this.logger.debug((Object)String.format("Status for task: %s is %s", id, status));
        return status;
    }

    public int getMaximumConcurrentTasks() {
        return this.properties.getMaximumConcurrentTasks();
    }

    public int getRunningTaskExecutionCount() {
        List<String> taskIds = this.getIdsForTasks(Optional.empty(), false);
        AtomicInteger executionCount = new AtomicInteger();
        taskIds.forEach(id -> {
            if (this.buildPodStatus((String)id).getState() == LaunchState.running) {
                executionCount.incrementAndGet();
            }
        });
        return executionCount.get();
    }

    public String getLog(String id) {
        if (this.properties.isCreateJob()) {
            Job job = this.getJob(id);
            HashMap<String, String> selector = new HashMap<String, String>();
            selector.put("spring-app-id", id);
            selector.put("job-name", job.getMetadata().getName());
            PodList podList = (PodList)((FilterWatchListDeletable)this.client.pods().withLabels(selector)).list();
            StringBuilder logAppender = new StringBuilder();
            for (Pod pod : podList.getItems()) {
                for (Container container : pod.getSpec().getContainers()) {
                    logAppender.append((String)((PrettyLoggable)((ContainerResource)((PodResource)this.client.pods().withName(pod.getMetadata().getName())).inContainer((Object)container.getName())).tailingLines(500)).getLog());
                }
            }
            return logAppender.toString();
        }
        HashMap<String, String> selector = new HashMap<String, String>();
        selector.put("spring-app-id", id);
        PodList podList = (PodList)((FilterWatchListDeletable)this.client.pods().withLabels(selector)).list();
        StringBuilder logAppender = new StringBuilder();
        for (Pod pod : podList.getItems()) {
            for (Container container : pod.getSpec().getContainers()) {
                logAppender.append((String)((PrettyLoggable)((ContainerResource)((PodResource)this.client.pods().withName(pod.getMetadata().getName())).inContainer((Object)container.getName())).tailingLines(500)).getLog());
            }
        }
        return logAppender.toString();
    }

    private boolean maxConcurrentExecutionsReached() {
        return this.getRunningTaskExecutionCount() >= this.getMaximumConcurrentTasks();
    }

    @Override
    protected String createDeploymentId(AppDeploymentRequest request) {
        String name = request.getDefinition().getName();
        Hashids hashids = new Hashids(name, 0, "abcdefghijklmnopqrstuvwxyz1234567890");
        String hashid = hashids.encode(new long[]{System.currentTimeMillis()});
        String deploymentId = name + "-" + hashid;
        return deploymentId.replace('.', '-').toLowerCase();
    }

    private void launch(String appId, AppDeploymentRequest request) {
        Map<String, String> idMap = this.createIdMap(appId, request);
        HashMap<String, String> podLabelMap = new HashMap<String, String>();
        podLabelMap.put("task-name", request.getDefinition().getName());
        podLabelMap.put("role", "spring-app");
        Map deploymentProperties = request.getDeploymentProperties();
        Map<String, String> deploymentLabels = this.deploymentPropertiesResolver.getDeploymentLabels(deploymentProperties);
        if (!CollectionUtils.isEmpty(deploymentLabels)) {
            this.logger.debug((Object)String.format("Adding deploymentLabels: %s", deploymentLabels));
        }
        PodSpec podSpec = this.createPodSpec(request);
        podSpec.setRestartPolicy(this.getRestartPolicy(request).name());
        if (this.properties.isCreateJob()) {
            this.logger.debug((Object)String.format("Launching Job for task: %s", appId));
            ObjectMeta objectMeta = ((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withLabels(podLabelMap)).addToLabels(idMap)).addToLabels(deploymentLabels)).withAnnotations(this.deploymentPropertiesResolver.getJobAnnotations(deploymentProperties))).addToAnnotations(this.deploymentPropertiesResolver.getPodAnnotations(deploymentProperties))).build();
            PodTemplateSpec podTemplateSpec = new PodTemplateSpec(objectMeta, podSpec);
            JobSpec jobSpec = ((JobSpecBuilder)((JobSpecBuilder)new JobSpecBuilder().withTemplate(podTemplateSpec)).withBackoffLimit(this.getBackoffLimit(request))).build();
            ((DoneableJob)((DoneableJob)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((DoneableJob)this.client.batch().jobs().createNew()).withNewMetadata().withName(appId)).withLabels(Collections.singletonMap("task-name", podLabelMap.get("task-name")))).addToLabels(idMap)).withAnnotations(this.deploymentPropertiesResolver.getJobAnnotations(deploymentProperties))).endMetadata()).withSpec(jobSpec)).done();
        } else {
            this.logger.debug((Object)String.format("Launching Pod for task: %s", appId));
            ((DoneablePod)((DoneablePod)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((DoneablePod)this.client.pods().createNew()).withNewMetadata().withName(appId)).withLabels(podLabelMap)).addToLabels(deploymentLabels)).withAnnotations(this.deploymentPropertiesResolver.getJobAnnotations(deploymentProperties))).addToAnnotations(this.deploymentPropertiesResolver.getPodAnnotations(deploymentProperties))).addToLabels(idMap)).endMetadata()).withSpec(podSpec)).done();
        }
    }

    private List<String> getIdsForTasks(Optional<String> taskName, boolean isCreateJob) {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            KubernetesResourceList<?> resourceList = this.getTaskResources(taskName, isCreateJob);
            for (HasMetadata hasMetadata : resourceList.getItems()) {
                ids.add(hasMetadata.getMetadata().getName());
            }
        }
        catch (KubernetesClientException kce) {
            this.logger.warn((Object)String.format("Failed to retrieve pods for task: %s", taskName), (Throwable)kce);
        }
        return ids;
    }

    private KubernetesResourceList<?> getTaskResources(Optional<String> taskName, boolean isCreateJob) {
        KubernetesResourceList resourceList = taskName.isPresent() ? (isCreateJob ? (KubernetesResourceList)((FilterWatchListDeletable)this.client.batch().jobs().withLabel("task-name", taskName.get())).list() : (KubernetesResourceList)((FilterWatchListDeletable)this.client.pods().withLabel("task-name", taskName.get())).list()) : (isCreateJob ? (KubernetesResourceList)((FilterWatchListDeletable)this.client.batch().jobs().withLabel("task-name")).list() : (KubernetesResourceList)((FilterWatchListDeletable)this.client.pods().withLabel("task-name")).list());
        return resourceList;
    }

    TaskStatus buildTaskStatus(String id) {
        if (this.properties.isCreateJob()) {
            boolean succeeded;
            Job job = this.getJob(id);
            if (job == null) {
                return new TaskStatus(id, LaunchState.unknown, new HashMap());
            }
            JobStatus jobStatus = job.getStatus();
            if (jobStatus == null) {
                return new TaskStatus(id, LaunchState.unknown, new HashMap());
            }
            boolean failed = jobStatus.getFailed() != null && jobStatus.getFailed() > 0;
            boolean bl = succeeded = jobStatus.getSucceeded() != null && jobStatus.getSucceeded() > 0;
            if (failed) {
                return new TaskStatus(id, LaunchState.failed, new HashMap());
            }
            if (succeeded) {
                return new TaskStatus(id, LaunchState.complete, new HashMap());
            }
            return new TaskStatus(id, LaunchState.launching, new HashMap());
        }
        return this.buildPodStatus(id);
    }

    private TaskStatus buildPodStatus(String id) {
        String phase;
        Pod pod = this.getPodByName(id);
        if (pod == null) {
            return new TaskStatus(id, LaunchState.unknown, new HashMap());
        }
        PodStatus podStatus = pod.getStatus();
        if (podStatus == null) {
            return new TaskStatus(id, LaunchState.unknown, new HashMap());
        }
        switch (phase = podStatus.getPhase()) {
            case "Pending": {
                return new TaskStatus(id, LaunchState.launching, new HashMap());
            }
            case "Failed": {
                return new TaskStatus(id, LaunchState.failed, new HashMap());
            }
            case "Succeeded": {
                return new TaskStatus(id, LaunchState.complete, new HashMap());
            }
        }
        return new TaskStatus(id, LaunchState.running, new HashMap());
    }

    private void deleteJob(String id) {
        FilterWatchListDeletable jobsToDelete = (FilterWatchListDeletable)this.client.batch().jobs().withLabel("spring-app-id", id);
        if (jobsToDelete != null && ((JobList)jobsToDelete.list()).getItems() != null) {
            this.logger.debug((Object)String.format("Deleting Job for task: %s", id));
            boolean jobDeleted = (Boolean)jobsToDelete.delete();
            this.logger.debug((Object)String.format("Job deleted for: %s - %b", id, jobDeleted));
        }
    }

    private void deletePod(String id) {
        FilterWatchListDeletable podsToDelete = (FilterWatchListDeletable)this.client.pods().withLabel("spring-app-id", id);
        if (podsToDelete != null && ((PodList)podsToDelete.list()).getItems() != null) {
            this.logger.debug((Object)String.format("Deleting Pod for task: %s", id));
            boolean podsDeleted = (Boolean)podsToDelete.delete();
            this.logger.debug((Object)String.format("Pod deleted for: %s - %b", id, podsDeleted));
        }
    }

    private Job getJob(String jobName) {
        List jobs = ((JobList)((FilterWatchListDeletable)this.client.batch().jobs().withLabel("spring-app-id", jobName)).list()).getItems();
        for (Job job : jobs) {
            if (!jobName.equals(job.getMetadata().getName())) continue;
            return job;
        }
        return null;
    }

    private Pod getPodByName(String name) {
        PodResource podResource = (PodResource)this.client.pods().withName(name);
        return podResource == null ? null : (Pod)((PodResource)this.client.pods().withName(name)).get();
    }

    protected RestartPolicy getRestartPolicy(AppDeploymentRequest request) {
        RestartPolicy restartPolicy;
        String restartPolicyString = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), "spring.cloud.deployer.kubernetes.restartPolicy");
        RestartPolicy restartPolicy2 = restartPolicy = !StringUtils.hasText((String)restartPolicyString) ? this.taskLauncherProperties.getRestartPolicy() : RestartPolicy.valueOf(restartPolicyString);
        if (this.properties.isCreateJob()) {
            Assert.isTrue((!restartPolicy.equals((Object)RestartPolicy.Always) ? 1 : 0) != 0, (String)"RestartPolicy should not be 'Always' when the JobSpec is used.");
        }
        return restartPolicy;
    }

    protected Integer getBackoffLimit(AppDeploymentRequest request) {
        String backoffLimitString = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), "spring.cloud.deployer.kubernetes.backoffLimit");
        if (StringUtils.hasText((String)backoffLimitString)) {
            return Integer.valueOf(backoffLimitString);
        }
        return this.taskLauncherProperties.getBackoffLimit();
    }
}

