/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.Secret;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;

public class ContainerConfiguration {
    private String appId;
    private Integer externalPort;
    private boolean isHostNetwork;
    private Secret probeCredentialsSecret;
    private AppDeploymentRequest appDeploymentRequest;

    public ContainerConfiguration(String appId, AppDeploymentRequest appDeploymentRequest) {
        this.appId = appId;
        this.appDeploymentRequest = appDeploymentRequest;
    }

    public AppDeploymentRequest getAppDeploymentRequest() {
        return this.appDeploymentRequest;
    }

    public String getAppId() {
        return this.appId;
    }

    public boolean isHostNetwork() {
        return this.isHostNetwork;
    }

    public ContainerConfiguration withHostNetwork(boolean isHostNetwork) {
        this.isHostNetwork = isHostNetwork;
        return this;
    }

    public ContainerConfiguration withExternalPort(Integer externalPort) {
        this.externalPort = externalPort;
        return this;
    }

    public Integer getExternalPort() {
        return this.externalPort;
    }

    public ContainerConfiguration withProbeCredentialsSecret(Secret probeCredentialsSecret) {
        this.probeCredentialsSecret = probeCredentialsSecret;
        return this;
    }

    public Secret getProbeCredentialsSecret() {
        return this.probeCredentialsSecret;
    }
}

