/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.support.RelaxedNames;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class PropertyParserUtils {
    PropertyParserUtils() {
    }

    static Map<String, String> getAnnotations(String annotation) {
        HashMap<String, String> annotations = new HashMap<String, String>();
        if (StringUtils.hasText((String)annotation)) {
            String[] annotationPairs;
            for (String annotationPair : annotationPairs = annotation.split(",")) {
                String[] splitAnnotation = annotationPair.split(":", 2);
                Assert.isTrue((splitAnnotation.length == 2 ? 1 : 0) != 0, (String)String.format("Invalid annotation value: %s", annotationPair));
                annotations.put(splitAnnotation[0].trim(), splitAnnotation[1].trim());
            }
        }
        return annotations;
    }

    static KubernetesDeployerProperties bindProperties(AppDeploymentRequest request, String propertyKey, String yamlLabel) {
        String deploymentPropertyValue = request.getDeploymentProperties().getOrDefault(propertyKey, "");
        KubernetesDeployerProperties deployerProperties = new KubernetesDeployerProperties();
        if (!StringUtils.isEmpty((Object)deploymentPropertyValue)) {
            try {
                YamlPropertiesFactoryBean properties = new YamlPropertiesFactoryBean();
                String tmpYaml = "{ " + yamlLabel + ": " + deploymentPropertyValue + " }";
                properties.setResources(new Resource[]{new ByteArrayResource(tmpYaml.getBytes())});
                Properties yaml = properties.getObject();
                MapConfigurationPropertySource source = new MapConfigurationPropertySource((Map)yaml);
                deployerProperties = (KubernetesDeployerProperties)new Binder(new ConfigurationPropertySource[]{source}).bind("", Bindable.of(KubernetesDeployerProperties.class)).get();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid binding property '%s'", deploymentPropertyValue), e);
            }
        }
        return deployerProperties;
    }

    static String getDeploymentPropertyValue(Map<String, String> deploymentProperties, String propertyName) {
        return PropertyParserUtils.getDeploymentPropertyValue(deploymentProperties, propertyName, null);
    }

    static String getDeploymentPropertyValue(Map<String, String> deploymentProperties, String propertyName, String defaultValue) {
        RelaxedNames relaxedNames = new RelaxedNames(propertyName);
        for (String relaxedName : relaxedNames) {
            if (!deploymentProperties.containsKey(relaxedName)) continue;
            return deploymentProperties.get(relaxedName);
        }
        return defaultValue;
    }
}

