/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.AffinityBuilder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.PodSecurityContextBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.ImagePullPolicy;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesAppInstanceStatus;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.PropertyParserUtils;
import org.springframework.cloud.deployer.spi.util.ByteSizeUtils;
import org.springframework.cloud.deployer.spi.util.RuntimeVersionUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AbstractKubernetesDeployer {
    protected static final String SPRING_DEPLOYMENT_KEY = "spring-deployment-id";
    protected static final String SPRING_GROUP_KEY = "spring-group-id";
    protected static final String SPRING_APP_KEY = "spring-app-id";
    protected static final String SPRING_MARKER_KEY = "role";
    protected static final String SPRING_MARKER_VALUE = "spring-app";
    protected final Log logger = LogFactory.getLog((String)this.getClass().getName());
    protected ContainerFactory containerFactory;
    protected KubernetesClient client;
    protected KubernetesDeployerProperties properties = new KubernetesDeployerProperties();

    protected RuntimeEnvironmentInfo createRuntimeEnvironmentInfo(Class spiClass, Class implementationClass) {
        return new RuntimeEnvironmentInfo.Builder().spiClass(spiClass).implementationName(implementationClass.getSimpleName()).implementationVersion(RuntimeVersionUtils.getVersion((Class)implementationClass)).platformType("Kubernetes").platformApiVersion(this.client.getApiVersion()).platformClientVersion(RuntimeVersionUtils.getVersion(this.client.getClass())).platformHostVersion("unknown").addPlatformSpecificInfo("master-url", String.valueOf(this.client.getMasterUrl())).addPlatformSpecificInfo("namespace", this.client.getNamespace()).build();
    }

    protected Map<String, String> createIdMap(String appId, AppDeploymentRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(SPRING_APP_KEY, appId);
        String groupId = (String)request.getDeploymentProperties().get("spring.cloud.deployer.group");
        if (groupId != null) {
            map.put(SPRING_GROUP_KEY, groupId);
        }
        map.put(SPRING_DEPLOYMENT_KEY, appId);
        return map;
    }

    protected AppStatus buildAppStatus(String id, PodList podList, ServiceList services) {
        AppStatus.Builder statusBuilder = AppStatus.of((String)id);
        Service service = null;
        if (podList != null && podList.getItems() != null) {
            block0: for (Pod pod : podList.getItems()) {
                String deploymentKey = (String)pod.getMetadata().getLabels().get(SPRING_DEPLOYMENT_KEY);
                for (Service svc : services.getItems()) {
                    if (!svc.getMetadata().getName().equals(deploymentKey)) continue;
                    service = svc;
                    break;
                }
                for (Container container : pod.getSpec().getContainers()) {
                    if (!container.getEnv().stream().anyMatch(envVar -> "SPRING_CLOUD_APPLICATION_GUID".equals(envVar.getName()))) continue;
                    Optional<ContainerStatus> containerStatusOptional = pod.getStatus().getContainerStatuses().stream().filter(containerStatus -> container.getName().equals(containerStatus.getName())).findFirst();
                    if (!containerStatusOptional.isPresent()) continue block0;
                    statusBuilder.with((AppInstanceStatus)new KubernetesAppInstanceStatus(pod, service, this.properties, containerStatusOptional.get()));
                    continue block0;
                }
            }
        }
        return statusBuilder.build();
    }

    protected PodSpec createPodSpec(String appId, AppDeploymentRequest request, Integer port, boolean neverRestart) {
        String deploymentServiceAcccountName;
        PodSpecBuilder podSpec = new PodSpecBuilder();
        String imagePullSecret = this.getImagePullSecret(request);
        if (imagePullSecret != null) {
            podSpec.addNewImagePullSecret(imagePullSecret);
        }
        boolean hostNetwork = this.getHostNetwork(request);
        ContainerConfiguration containerConfiguration = new ContainerConfiguration(appId, request).withProbeCredentialsSecret(this.getProbeCredentialsSecret(request)).withExternalPort(port).withHostNetwork(hostNetwork);
        Container container = this.containerFactory.create(containerConfiguration);
        ResourceRequirements req = new ResourceRequirements();
        req.setLimits(this.deduceResourceLimits(request));
        req.setRequests(this.deduceResourceRequests(request));
        container.setResources(req);
        ImagePullPolicy pullPolicy = this.deduceImagePullPolicy(request);
        container.setImagePullPolicy(pullPolicy.name());
        Map<String, String> nodeSelectors = this.getNodeSelectors(request.getDeploymentProperties());
        if (nodeSelectors.size() > 0) {
            podSpec.withNodeSelector(nodeSelectors);
        }
        podSpec.withTolerations(this.getTolerations(request));
        podSpec.withVolumes(this.getVolumes(request).stream().filter(volume -> container.getVolumeMounts().stream().anyMatch(volumeMount -> volumeMount.getName().equals(volume.getName()))).collect(Collectors.toList()));
        if (hostNetwork) {
            podSpec.withHostNetwork(Boolean.valueOf(true));
        }
        podSpec.addToContainers(new Container[]{container});
        if (neverRestart) {
            podSpec.withRestartPolicy("Never");
        }
        if ((deploymentServiceAcccountName = this.getDeploymentServiceAccountName(request)) != null) {
            podSpec.withServiceAccountName(deploymentServiceAcccountName);
        }
        this.setPodSecurityContext(request, podSpec);
        this.setAffinityRules(request, podSpec);
        this.setInitContainer(request, podSpec);
        return podSpec.build();
    }

    private List<Toleration> getTolerations(AppDeploymentRequest request) {
        ArrayList<Toleration> tolerations = new ArrayList<Toleration>();
        KubernetesDeployerProperties deployerProperties = PropertyParserUtils.bindProperties(request, "spring.cloud.deployer.kubernetes.tolerations", "tolerations");
        deployerProperties.getTolerations().forEach(toleration -> tolerations.add(new Toleration(toleration.getEffect(), toleration.getKey(), toleration.getOperator(), toleration.getTolerationSeconds(), toleration.getValue())));
        this.properties.getTolerations().stream().filter(toleration -> tolerations.stream().noneMatch(existing -> existing.getKey().equals(toleration.getKey()))).collect(Collectors.toList()).forEach(toleration -> tolerations.add(new Toleration(toleration.getEffect(), toleration.getKey(), toleration.getOperator(), toleration.getTolerationSeconds(), toleration.getValue())));
        return tolerations;
    }

    protected List<Volume> getVolumes(AppDeploymentRequest request) {
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        KubernetesDeployerProperties deployerProperties = PropertyParserUtils.bindProperties(request, "spring.cloud.deployer.kubernetes.volumes", "volumes");
        volumes.addAll(deployerProperties.getVolumes());
        volumes.addAll(this.properties.getVolumes().stream().filter(volume -> volumes.stream().noneMatch(existingVolume -> existingVolume.getName().equals(volume.getName()))).collect(Collectors.toList()));
        return volumes;
    }

    protected Map<String, Quantity> deduceResourceLimits(AppDeploymentRequest request) {
        String cpu;
        String memory = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), "spring.cloud.deployer.kubernetes.limits.memory");
        if (StringUtils.isEmpty((Object)memory)) {
            memory = this.properties.getLimits().getMemory();
        }
        if (StringUtils.isEmpty((Object)(cpu = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), "spring.cloud.deployer.kubernetes.limits.cpu")))) {
            cpu = this.properties.getLimits().getCpu();
        }
        HashMap<String, Quantity> limits = new HashMap<String, Quantity>();
        limits.put("memory", new Quantity(memory));
        limits.put("cpu", new Quantity(cpu));
        this.logger.debug((Object)("Using limits - cpu: " + cpu + " mem: " + memory));
        return limits;
    }

    protected ImagePullPolicy deduceImagePullPolicy(AppDeploymentRequest request) {
        ImagePullPolicy pullPolicy;
        String pullPolicyOverride = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), "spring.cloud.deployer.kubernetes.imagePullPolicy");
        if (pullPolicyOverride == null) {
            pullPolicy = this.properties.getImagePullPolicy();
        } else {
            pullPolicy = ImagePullPolicy.relaxedValueOf(pullPolicyOverride);
            if (pullPolicy == null) {
                this.logger.warn((Object)("Parsing of pull policy " + pullPolicyOverride + " failed, using default \"IfNotPresent\"."));
                pullPolicy = ImagePullPolicy.IfNotPresent;
            }
        }
        this.logger.debug((Object)("Using imagePullPolicy " + (Object)((Object)pullPolicy)));
        return pullPolicy;
    }

    protected Map<String, Quantity> deduceResourceRequests(AppDeploymentRequest request) {
        String cpuOverride;
        String memOverride = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), "spring.cloud.deployer.kubernetes.requests.memory");
        if (memOverride == null) {
            memOverride = this.properties.getRequests().getMemory();
        }
        if ((cpuOverride = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), "spring.cloud.deployer.kubernetes.requests.cpu")) == null) {
            cpuOverride = this.properties.getRequests().getCpu();
        }
        this.logger.debug((Object)("Using requests - cpu: " + cpuOverride + " mem: " + memOverride));
        HashMap<String, Quantity> requests = new HashMap<String, Quantity>();
        if (memOverride != null) {
            requests.put("memory", new Quantity(memOverride));
        }
        if (cpuOverride != null) {
            requests.put("cpu", new Quantity(cpuOverride));
        }
        return requests;
    }

    protected String getStatefulSetStorageClassName(AppDeploymentRequest request) {
        String storageClassName = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), "spring.cloud.deployer.kubernetes.statefulSet.volumeClaimTemplate.storageClassName");
        if (storageClassName == null && this.properties.getStatefulSet() != null && this.properties.getStatefulSet().getVolumeClaimTemplate() != null) {
            storageClassName = this.properties.getStatefulSet().getVolumeClaimTemplate().getStorageClassName();
        }
        return storageClassName;
    }

    protected String getStatefulSetStorage(AppDeploymentRequest request) {
        String storage = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), "spring.cloud.deployer.kubernetes.statefulSet.volumeClaimTemplate.storage");
        if (storage == null && this.properties.getStatefulSet() != null && this.properties.getStatefulSet().getVolumeClaimTemplate() != null) {
            storage = this.properties.getStatefulSet().getVolumeClaimTemplate().getStorage();
        }
        long storageAmount = ByteSizeUtils.parseToMebibytes((String)storage);
        return storageAmount + "Mi";
    }

    protected boolean getHostNetwork(AppDeploymentRequest request) {
        String hostNetworkOverride = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), "spring.cloud.deployer.kubernetes.hostNetwork");
        boolean hostNetwork = StringUtils.isEmpty((Object)hostNetworkOverride) ? this.properties.isHostNetwork() : Boolean.valueOf(hostNetworkOverride).booleanValue();
        this.logger.debug((Object)("Using hostNetwork " + hostNetwork));
        return hostNetwork;
    }

    private Map<String, String> getNodeSelectors(Map<String, String> deploymentProperties) {
        HashMap<String, String> nodeSelectors = new HashMap<String, String>();
        String nodeSelector = this.properties.getNodeSelector();
        String nodeSelectorDeploymentProperty = deploymentProperties.getOrDefault("spring.cloud.deployer.kubernetes.deployment.nodeSelector", "");
        boolean hasGlobalNodeSelector = StringUtils.hasText((String)this.properties.getNodeSelector());
        boolean hasDeployerPropertyNodeSelector = StringUtils.hasText((String)nodeSelectorDeploymentProperty);
        if (hasGlobalNodeSelector && hasDeployerPropertyNodeSelector || !hasGlobalNodeSelector && hasDeployerPropertyNodeSelector) {
            nodeSelector = nodeSelectorDeploymentProperty;
        }
        if (StringUtils.hasText((String)nodeSelector)) {
            String[] nodeSelectorPairs;
            for (String nodeSelectorPair : nodeSelectorPairs = nodeSelector.split(",")) {
                String[] selector = nodeSelectorPair.split(":");
                Assert.isTrue((selector.length == 2 ? 1 : 0) != 0, (String)String.format("Invalid nodeSelector value: '{}'", nodeSelectorPair));
                nodeSelectors.put(selector[0].trim(), selector[1].trim());
            }
        }
        return nodeSelectors;
    }

    protected void logPossibleDownloadResourceMessage(org.springframework.core.io.Resource resource) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Preparing to run a container from  " + resource + ". This may take some time if the image must be downloaded from a remote container registry."));
        }
    }

    private String getImagePullSecret(AppDeploymentRequest request) {
        String imagePullSecret = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), "spring.cloud.deployer.kubernetes.imagePullSecret", "");
        if (StringUtils.isEmpty((Object)imagePullSecret)) {
            imagePullSecret = this.properties.getImagePullSecret();
        }
        return imagePullSecret;
    }

    private String getDeploymentServiceAccountName(AppDeploymentRequest request) {
        String deploymentServiceAccountName = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), "spring.cloud.deployer.kubernetes.deploymentServiceAccountName");
        if (StringUtils.isEmpty((Object)deploymentServiceAccountName)) {
            deploymentServiceAccountName = this.properties.getDeploymentServiceAccountName();
        }
        return deploymentServiceAccountName;
    }

    private Secret getProbeCredentialsSecret(AppDeploymentRequest request) {
        String secretName = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), "spring.cloud.deployer.kubernetes.probeCredentialsSecret");
        if (!StringUtils.isEmpty((Object)secretName)) {
            return (Secret)((Resource)this.client.secrets().withName(secretName)).get();
        }
        return null;
    }

    private void setPodSecurityContext(AppDeploymentRequest request, PodSpecBuilder podSpecBuilder) {
        PodSecurityContext podSecurityContext = null;
        KubernetesDeployerProperties deployerProperties = PropertyParserUtils.bindProperties(request, "spring.cloud.deployer.kubernetes.podSecurityContext", "podSecurityContext");
        if (deployerProperties.getPodSecurityContext() != null) {
            podSecurityContext = ((PodSecurityContextBuilder)((PodSecurityContextBuilder)new PodSecurityContextBuilder().withRunAsUser(deployerProperties.getPodSecurityContext().getRunAsUser())).withFsGroup(deployerProperties.getPodSecurityContext().getFsGroup())).build();
        } else {
            String runAsUser = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), "spring.cloud.deployer.kubernetes.podSecurityContext.runAsUser");
            String fsGroup = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), "spring.cloud.deployer.kubernetes.podSecurityContext.fsGroup");
            if (!StringUtils.isEmpty((Object)runAsUser) && !StringUtils.isEmpty((Object)fsGroup)) {
                podSecurityContext = ((PodSecurityContextBuilder)((PodSecurityContextBuilder)new PodSecurityContextBuilder().withRunAsUser(Long.valueOf(runAsUser))).withFsGroup(Long.valueOf(fsGroup))).build();
            } else if (this.properties.getPodSecurityContext() != null) {
                podSecurityContext = ((PodSecurityContextBuilder)((PodSecurityContextBuilder)new PodSecurityContextBuilder().withRunAsUser(this.properties.getPodSecurityContext().getRunAsUser())).withFsGroup(this.properties.getPodSecurityContext().getFsGroup())).build();
            }
        }
        if (podSecurityContext != null) {
            podSpecBuilder.withSecurityContext(podSecurityContext);
        }
    }

    private void setAffinityRules(AppDeploymentRequest request, PodSpecBuilder podSpecBuilder) {
        Affinity affinity = new Affinity();
        String nodeAffinityPropertyKey = "spring.cloud.deployer.kubernetes.affinity.nodeAffinity";
        String podAffinityPropertyKey = "spring.cloud.deployer.kubernetes.affinity.podAffinity";
        String podAntiAffinityPropertyKey = "spring.cloud.deployer.kubernetes.affinity.podAntiAffinity";
        String nodeAffinityValue = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), nodeAffinityPropertyKey);
        String podAffinityValue = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), podAffinityPropertyKey);
        String podAntiAffinityValue = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), podAntiAffinityPropertyKey);
        if (this.properties.getNodeAffinity() != null && !StringUtils.hasText((String)nodeAffinityValue)) {
            affinity.setNodeAffinity(((AffinityBuilder)new AffinityBuilder().withNodeAffinity(this.properties.getNodeAffinity())).buildNodeAffinity());
        } else if (StringUtils.hasText((String)nodeAffinityValue)) {
            KubernetesDeployerProperties nodeAffinityProperties = PropertyParserUtils.bindProperties(request, nodeAffinityPropertyKey, "nodeAffinity");
            affinity.setNodeAffinity(((AffinityBuilder)new AffinityBuilder().withNodeAffinity(nodeAffinityProperties.getNodeAffinity())).buildNodeAffinity());
        }
        if (this.properties.getPodAffinity() != null && !StringUtils.hasText((String)podAffinityValue)) {
            affinity.setPodAffinity(((AffinityBuilder)new AffinityBuilder().withPodAffinity(this.properties.getPodAffinity())).buildPodAffinity());
        } else if (StringUtils.hasText((String)podAffinityValue)) {
            KubernetesDeployerProperties podAffinityProperties = PropertyParserUtils.bindProperties(request, podAffinityPropertyKey, "podAffinity");
            affinity.setPodAffinity(((AffinityBuilder)new AffinityBuilder().withPodAffinity(podAffinityProperties.getPodAffinity())).buildPodAffinity());
        }
        if (this.properties.getPodAntiAffinity() != null && !StringUtils.hasText((String)podAntiAffinityValue)) {
            affinity.setPodAntiAffinity(((AffinityBuilder)new AffinityBuilder().withPodAntiAffinity(this.properties.getPodAntiAffinity())).buildPodAntiAffinity());
        } else if (StringUtils.hasText((String)podAntiAffinityValue)) {
            KubernetesDeployerProperties podAntiAffinityProperties = PropertyParserUtils.bindProperties(request, podAntiAffinityPropertyKey, "podAntiAffinity");
            affinity.setPodAntiAffinity(((AffinityBuilder)new AffinityBuilder().withPodAntiAffinity(podAntiAffinityProperties.getPodAntiAffinity())).buildPodAntiAffinity());
        }
        if (affinity.getNodeAffinity() != null || affinity.getPodAffinity() != null || affinity.getPodAntiAffinity() != null) {
            podSpecBuilder.withAffinity(affinity);
        }
    }

    private void setInitContainer(AppDeploymentRequest request, PodSpecBuilder podSpec) {
        KubernetesDeployerProperties deployerProperties = PropertyParserUtils.bindProperties(request, "spring.cloud.deployer.kubernetes.initContainer", "initContainer");
        if (deployerProperties.getInitContainer() == null) {
            String containerName = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), "spring.cloud.deployer.kubernetes.initContainer.containerName");
            String imageName = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), "spring.cloud.deployer.kubernetes.initContainer.imageName");
            String commands = PropertyParserUtils.getDeploymentPropertyValue(request.getDeploymentProperties(), "spring.cloud.deployer.kubernetes.initContainer.commands");
            if (!StringUtils.isEmpty((Object)containerName) && !StringUtils.isEmpty((Object)imageName)) {
                Container container = ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(containerName)).withImage(imageName)).withCommand(new String[]{commands})).build();
                podSpec.addToInitContainers(new Container[]{container});
            }
        } else {
            KubernetesDeployerProperties.InitContainer initContainer = deployerProperties.getInitContainer();
            if (initContainer != null) {
                Container container = ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(initContainer.getContainerName())).withImage(initContainer.getImageName())).withCommand(initContainer.getCommands())).build();
                podSpec.addToInitContainers(new Container[]{container});
            }
        }
    }
}

