/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.scheduler.kubernetes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.deployer.spi.kubernetes.EntryPointStyle;
import org.springframework.cloud.deployer.spi.scheduler.ScheduleRequest;
import org.springframework.cloud.deployer.spi.scheduler.kubernetes.KubernetesSchedulerProperties;
import org.springframework.cloud.deployer.spi.scheduler.kubernetes.KubernetesSchedulerPropertyResolver;
import org.springframework.util.Assert;

class ContainerCreator {
    private final ScheduleRequest scheduleRequest;
    private final KubernetesSchedulerProperties kubernetesSchedulerProperties;

    ContainerCreator(ScheduleRequest scheduleRequest) {
        this(new KubernetesSchedulerProperties(), scheduleRequest);
    }

    public ContainerCreator(KubernetesSchedulerProperties kubernetesSchedulerProperties, ScheduleRequest scheduleRequest) {
        Assert.notNull((Object)scheduleRequest, (String)"ScheduleRequest must not be null");
        Assert.notNull((Object)kubernetesSchedulerProperties, (String)"KubernetesSchedulerProperties must not be null");
        Assert.hasText((String)scheduleRequest.getScheduleName(), (String)"ScheduleRequest must contain schedule name");
        this.scheduleRequest = scheduleRequest;
        this.kubernetesSchedulerProperties = kubernetesSchedulerProperties;
    }

    public Container build() {
        String imagePullPolicy = KubernetesSchedulerPropertyResolver.getImagePullPolicy(this.scheduleRequest, this.kubernetesSchedulerProperties);
        return ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(this.scheduleRequest.getScheduleName())).withImage(this.getImage())).withImagePullPolicy(imagePullPolicy)).withEnv(this.getContainerParameters().getEnvironmentVariables())).withArgs(this.getContainerParameters().getCommandLineArguments())).build();
    }

    private String getImage() {
        String image;
        try {
            image = this.scheduleRequest.getResource().getURI().getSchemeSpecificPart();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to get image name from: " + this.scheduleRequest.getResource(), e);
        }
        return image;
    }

    private ContainerParameters getContainerParameters() {
        ArrayList<EnvVar> environmentVariables = new ArrayList<EnvVar>();
        ArrayList<String> commandLineArguments = new ArrayList<String>();
        HashMap<String, String> envVarsMap = new HashMap<String, String>();
        envVarsMap.putAll(KubernetesSchedulerPropertyResolver.getTaskEnvironmentVariables(this.scheduleRequest, this.kubernetesSchedulerProperties));
        environmentVariables.addAll(envVarsMap.entrySet().stream().map(e -> new EnvVar((String)e.getKey(), (String)e.getValue(), null)).collect(Collectors.toList()));
        EntryPointStyle entryPointStyle = KubernetesSchedulerPropertyResolver.getEntryPointStyle(this.scheduleRequest, this.kubernetesSchedulerProperties);
        switch (entryPointStyle) {
            case exec: {
                commandLineArguments.addAll(this.createCommandLineArguments());
                break;
            }
            case boot: {
                try {
                    environmentVariables.add(new EnvVar("SPRING_APPLICATION_JSON", new ObjectMapper().writeValueAsString((Object)this.scheduleRequest.getDefinition().getProperties()), null));
                }
                catch (JsonProcessingException e2) {
                    throw new IllegalStateException("Unable to create SPRING_APPLICATION_JSON", e2);
                }
                commandLineArguments.addAll(this.scheduleRequest.getCommandlineArguments());
                break;
            }
            case shell: {
                environmentVariables.addAll(this.createEnvironmentVariables());
            }
        }
        return new ContainerParameters(environmentVariables, commandLineArguments);
    }

    protected List<String> createCommandLineArguments() {
        ArrayList<String> commandLineArguments = new ArrayList<String>();
        Map applicationProperties = this.scheduleRequest.getDefinition().getProperties();
        commandLineArguments.addAll(applicationProperties.entrySet().stream().map(entry -> String.format("--%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.toList()));
        commandLineArguments.addAll(this.scheduleRequest.getCommandlineArguments());
        return commandLineArguments;
    }

    protected List<EnvVar> createEnvironmentVariables() {
        ArrayList<EnvVar> environmentVariables = new ArrayList<EnvVar>();
        for (String environmentVariable : this.scheduleRequest.getDefinition().getProperties().keySet()) {
            String transformedEnvironmentVariable = environmentVariable.replace('.', '_').toUpperCase();
            environmentVariables.add(new EnvVar(transformedEnvironmentVariable, (String)this.scheduleRequest.getDefinition().getProperties().get(environmentVariable), null));
        }
        return environmentVariables;
    }

    private static class ContainerParameters {
        private final List<EnvVar> environmentVariables;
        private final List<String> commandLineArguments;

        ContainerParameters(List<EnvVar> environmentVariables, List<String> commandLineArguments) {
            this.environmentVariables = environmentVariables != null ? environmentVariables : Collections.emptyList();
            this.commandLineArguments = commandLineArguments != null ? commandLineArguments : Collections.emptyList();
        }

        List<EnvVar> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        List<String> getCommandLineArguments() {
            return this.commandLineArguments;
        }
    }
}

