/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.DefaultContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesAppDeployer;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesClientFactory;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesTaskLauncher;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={KubernetesDeployerProperties.class})
@AutoConfigureOrder(value=-2147483648)
public class KubernetesAutoConfiguration {
    @Autowired
    private KubernetesDeployerProperties properties;

    @Bean
    @ConditionalOnMissingBean(value={AppDeployer.class})
    public AppDeployer appDeployer(KubernetesClient kubernetesClient, ContainerFactory containerFactory) {
        return new KubernetesAppDeployer(this.properties, kubernetesClient, containerFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={TaskLauncher.class})
    public TaskLauncher taskDeployer(KubernetesClient kubernetesClient, ContainerFactory containerFactory) {
        return new KubernetesTaskLauncher(this.properties, kubernetesClient, containerFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={KubernetesClient.class})
    public KubernetesClient kubernetesClient() {
        return KubernetesClientFactory.getKubernetesClient(this.properties);
    }

    @Bean
    public ContainerFactory containerFactory() {
        return new DefaultContainerFactory(this.properties);
    }
}

