/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarSource;
import io.fabric8.kubernetes.api.model.ObjectFieldSelector;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.EntryPointStyle;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.LivenessProbeCreator;
import org.springframework.cloud.deployer.spi.kubernetes.ReadinessProbeCreator;
import org.springframework.cloud.deployer.spi.util.CommandLineTokenizer;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultContainerFactory
implements ContainerFactory {
    private static Log logger = LogFactory.getLog(DefaultContainerFactory.class);
    private final KubernetesDeployerProperties properties;
    private final NestedCommaDelimitedVariableParser nestedCommaDelimitedVariableParser = new NestedCommaDelimitedVariableParser();

    public DefaultContainerFactory(KubernetesDeployerProperties properties) {
        this.properties = properties;
    }

    @Override
    public Container create(ContainerConfiguration containerConfiguration) {
        List<String> containerCommand;
        String image;
        AppDeploymentRequest request = containerConfiguration.getAppDeploymentRequest();
        try {
            image = request.getResource().getURI().getSchemeSpecificPart();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to get URI for " + request.getResource(), e);
        }
        logger.info((Object)("Using Docker image: " + image));
        EntryPointStyle entryPointStyle = this.determineEntryPointStyle(this.properties, request);
        logger.info((Object)("Using Docker entry point style: " + (Object)((Object)entryPointStyle)));
        HashMap<String, String> envVarsMap = new HashMap<String, String>();
        for (String envVar : this.properties.getEnvironmentVariables()) {
            String[] strings = envVar.split("=", 2);
            Assert.isTrue((strings.length == 2 ? 1 : 0) != 0, (String)("Invalid environment variable declared: " + envVar));
            envVarsMap.put(strings[0], strings[1]);
        }
        envVarsMap.putAll(this.getAppEnvironmentVariables(request));
        List<Object> appArgs = new ArrayList();
        switch (entryPointStyle) {
            case exec: {
                appArgs = this.createCommandArgs(request);
                break;
            }
            case boot: {
                if (envVarsMap.containsKey("SPRING_APPLICATION_JSON")) {
                    throw new IllegalStateException("You can't use boot entry point style and also set SPRING_APPLICATION_JSON for the app");
                }
                try {
                    envVarsMap.put("SPRING_APPLICATION_JSON", new ObjectMapper().writeValueAsString((Object)request.getDefinition().getProperties()));
                }
                catch (JsonProcessingException e) {
                    throw new IllegalStateException("Unable to create SPRING_APPLICATION_JSON", e);
                }
                appArgs = request.getCommandlineArguments();
                break;
            }
            case shell: {
                for (String key : request.getDefinition().getProperties().keySet()) {
                    String envVar;
                    envVar = key.replace('.', '_').toUpperCase();
                    envVarsMap.put(envVar, (String)request.getDefinition().getProperties().get(key));
                }
                break;
            }
        }
        ArrayList<EnvVar> envVars = new ArrayList<EnvVar>();
        for (Map.Entry e : envVarsMap.entrySet()) {
            envVars.add(new EnvVar((String)e.getKey(), (String)e.getValue(), null));
        }
        envVars.add(this.getGUIDEnvVar());
        if (request.getDeploymentProperties().get("spring.cloud.deployer.group") != null) {
            envVars.add(new EnvVar("SPRING_CLOUD_APPLICATION_GROUP", (String)request.getDeploymentProperties().get("spring.cloud.deployer.group"), null));
        }
        ContainerBuilder container = new ContainerBuilder();
        ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)container.withName(containerConfiguration.getAppId())).withImage(image)).withEnv(envVars)).withArgs(appArgs)).withVolumeMounts(this.getVolumeMounts(request));
        HashSet<Integer> ports = new HashSet<Integer>();
        Integer defaultPort = containerConfiguration.getExternalPort();
        if (defaultPort != null) {
            ports.add(defaultPort);
        }
        ports.addAll(this.getContainerPorts(request));
        this.configureReadinessProbe(containerConfiguration, container, ports);
        this.configureLivenessProbe(containerConfiguration, container, ports);
        if (!ports.isEmpty()) {
            for (Integer containerPort : ports) {
                if (containerConfiguration.isHostNetwork()) {
                    ((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)container.addNewPort().withContainerPort(containerPort)).withHostPort(containerPort)).endPort();
                    continue;
                }
                ((ContainerFluent.PortsNested)container.addNewPort().withContainerPort(containerPort)).endPort();
            }
        }
        if (!(containerCommand = this.getContainerCommand(request)).isEmpty()) {
            container.withCommand(containerCommand);
        }
        return container.build();
    }

    private EnvVar getGUIDEnvVar() {
        ObjectFieldSelector objectFieldSelector = new ObjectFieldSelector();
        objectFieldSelector.setFieldPath("metadata.uid");
        EnvVarSource envVarSource = new EnvVarSource();
        envVarSource.setFieldRef(objectFieldSelector);
        EnvVar guidEnvVar = new EnvVar();
        guidEnvVar.setValueFrom(envVarSource);
        guidEnvVar.setName("SPRING_CLOUD_APPLICATION_GUID");
        return guidEnvVar;
    }

    private void configureReadinessProbe(ContainerConfiguration containerConfiguration, ContainerBuilder containerBuilder, Set<Integer> ports) {
        Probe readinessProbe = new ReadinessProbeCreator(this.properties, containerConfiguration).create();
        Integer readinessProbePort = readinessProbe.getHttpGet().getPort().getIntVal();
        if (readinessProbePort != null) {
            containerBuilder.withReadinessProbe(readinessProbe);
            ports.add(readinessProbePort);
        }
    }

    private void configureLivenessProbe(ContainerConfiguration containerConfiguration, ContainerBuilder containerBuilder, Set<Integer> ports) {
        Probe livenessProbe = new LivenessProbeCreator(this.properties, containerConfiguration).create();
        Integer livenessProbePort = livenessProbe.getHttpGet().getPort().getIntVal();
        if (livenessProbePort != null) {
            containerBuilder.withLivenessProbe(livenessProbe);
            ports.add(livenessProbePort);
        }
    }

    protected List<String> createCommandArgs(AppDeploymentRequest request) {
        LinkedList<String> cmdArgs = new LinkedList<String>();
        Map args = request.getDefinition().getProperties();
        for (Map.Entry entry : args.entrySet()) {
            cmdArgs.add(String.format("--%s=%s", entry.getKey(), entry.getValue()));
        }
        cmdArgs.addAll(request.getCommandlineArguments());
        logger.debug((Object)("Using command args: " + cmdArgs));
        return cmdArgs;
    }

    protected List<VolumeMount> getVolumeMounts(AppDeploymentRequest request) {
        ArrayList<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
        String volumeMountDeploymentProperty = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.kubernetes.volumeMounts", "");
        if (!StringUtils.isEmpty((Object)volumeMountDeploymentProperty)) {
            try {
                YamlPropertiesFactoryBean properties = new YamlPropertiesFactoryBean();
                String tmpYaml = "{ volume-mounts: " + volumeMountDeploymentProperty + " }";
                properties.setResources(new Resource[]{new ByteArrayResource(tmpYaml.getBytes())});
                Properties yaml = properties.getObject();
                MapConfigurationPropertySource source = new MapConfigurationPropertySource((Map)yaml);
                KubernetesDeployerProperties deployerProperties = (KubernetesDeployerProperties)new Binder(new ConfigurationPropertySource[]{source}).bind("", Bindable.of(KubernetesDeployerProperties.class)).get();
                volumeMounts.addAll(deployerProperties.getVolumeMounts());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid volume mount '%s'", volumeMountDeploymentProperty), e);
            }
        }
        volumeMounts.addAll(this.properties.getVolumeMounts().stream().filter(volumeMount -> volumeMounts.stream().noneMatch(existingVolumeMount -> existingVolumeMount.getName().equals(volumeMount.getName()))).collect(Collectors.toList()));
        return volumeMounts;
    }

    private List<String> getContainerCommand(AppDeploymentRequest request) {
        String containerCommand = request.getDeploymentProperties().getOrDefault("spring.cloud.deployer.kubernetes.containerCommand", "");
        return new CommandLineTokenizer(containerCommand).getArgs();
    }

    private List<Integer> getContainerPorts(AppDeploymentRequest request) {
        ArrayList<Integer> containerPortList = new ArrayList<Integer>();
        String containerPorts = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.containerPorts");
        if (containerPorts != null) {
            String[] containerPortSplit;
            for (String containerPort : containerPortSplit = containerPorts.split(",")) {
                logger.trace((Object)("Adding container ports from AppDeploymentRequest: " + containerPort));
                Integer port = Integer.parseInt(containerPort.trim());
                containerPortList.add(port);
            }
        }
        return containerPortList;
    }

    private Map<String, String> getAppEnvironmentVariables(AppDeploymentRequest request) {
        HashMap<String, String> appEnvVarMap = new HashMap<String, String>();
        String appEnvVar = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.environmentVariables");
        if (appEnvVar != null) {
            String[] appEnvVars;
            for (String envVar : appEnvVars = this.nestedCommaDelimitedVariableParser.parse(appEnvVar)) {
                logger.trace((Object)("Adding environment variable from AppDeploymentRequest: " + envVar));
                String[] strings = envVar.split("=", 2);
                Assert.isTrue((strings.length == 2 ? 1 : 0) != 0, (String)("Invalid environment variable declared: " + envVar));
                appEnvVarMap.put(strings[0], strings[1]);
            }
        }
        return appEnvVarMap;
    }

    private EntryPointStyle determineEntryPointStyle(KubernetesDeployerProperties properties, AppDeploymentRequest request) {
        EntryPointStyle entryPointStyle = null;
        String deployProperty = (String)request.getDeploymentProperties().get("spring.cloud.deployer.kubernetes.entryPointStyle");
        if (deployProperty != null) {
            try {
                entryPointStyle = EntryPointStyle.valueOf(deployProperty.toLowerCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (entryPointStyle == null) {
            entryPointStyle = properties.getEntryPointStyle();
        }
        return entryPointStyle;
    }

    static class NestedCommaDelimitedVariableParser {
        static final String REGEX = "(\\w+='.+?'),?";
        static final Pattern pattern = Pattern.compile("(\\w+='.+?'),?");

        NestedCommaDelimitedVariableParser() {
        }

        String[] parse(String value) {
            String[] vars = value.replaceAll(pattern.pattern(), "").split(",");
            Matcher m = pattern.matcher(value);
            while (m.find()) {
                vars = Arrays.copyOf(vars, vars.length + 1);
                vars[vars.length - 1] = m.group(1).replaceAll("'", "");
            }
            return vars;
        }
    }
}

