/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.cloud.deployer.spi.kubernetes.ContainerConfiguration;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.ProbeCreator;

class LivenessProbeCreator
extends ProbeCreator {
    private static final String PROBE_PROPERTY_PREFIX = "spring.cloud.deployer.kubernetes.liveness";

    public LivenessProbeCreator(KubernetesDeployerProperties kubernetesDeployerProperties, ContainerConfiguration containerConfiguration) {
        super(kubernetesDeployerProperties, containerConfiguration);
    }

    @Override
    public Integer getPort() {
        String probePortKey = "spring.cloud.deployer.kubernetes.livenessProbePort";
        if (this.getDeploymentProperties().containsKey(probePortKey)) {
            return Integer.parseInt(this.getDeploymentProperties().get(probePortKey));
        }
        if (this.getKubernetesDeployerProperties().getLivenessProbePort() != null) {
            return this.getKubernetesDeployerProperties().getLivenessProbePort();
        }
        if (this.getDefaultPort() != null) {
            return this.getDefaultPort();
        }
        return null;
    }

    @Override
    protected String getProbePath() {
        String probePathKey = "spring.cloud.deployer.kubernetes.livenessProbePath";
        if (this.getDeploymentProperties().containsKey(probePathKey)) {
            return this.getDeploymentProperties().get(probePathKey);
        }
        if (this.getKubernetesDeployerProperties().getLivenessProbePath() != null) {
            return this.getKubernetesDeployerProperties().getLivenessProbePath();
        }
        if (this.useBoot2ProbePath()) {
            return "/actuator/health";
        }
        return "/health";
    }

    @Override
    protected int getTimeout() {
        String probeTimeoutKey = "spring.cloud.deployer.kubernetes.livenessProbeTimeout";
        if (this.getDeploymentProperties().containsKey(probeTimeoutKey)) {
            return Integer.valueOf(this.getDeploymentProperties().get(probeTimeoutKey));
        }
        return this.getKubernetesDeployerProperties().getLivenessProbeTimeout();
    }

    @Override
    protected int getInitialDelay() {
        String probeDelayKey = "spring.cloud.deployer.kubernetes.livenessProbeDelay";
        if (this.getDeploymentProperties().containsKey(probeDelayKey)) {
            return Integer.valueOf(this.getDeploymentProperties().get(probeDelayKey));
        }
        return this.getKubernetesDeployerProperties().getLivenessProbeDelay();
    }

    @Override
    protected int getPeriod() {
        String probePeriodKey = "spring.cloud.deployer.kubernetes.livenessProbePeriod";
        if (this.getDeploymentProperties().containsKey(probePeriodKey)) {
            return Integer.valueOf(this.getDeploymentProperties().get(probePeriodKey));
        }
        return this.getKubernetesDeployerProperties().getLivenessProbePeriod();
    }
}

