/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.DoneableJob;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Job;
import io.fabric8.kubernetes.api.model.JobFluent;
import io.fabric8.kubernetes.api.model.JobSpec;
import io.fabric8.kubernetes.api.model.JobSpecBuilder;
import io.fabric8.kubernetes.api.model.JobStatus;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hashids.Hashids;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.kubernetes.AbstractKubernetesDeployer;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.DefaultContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.task.LaunchState;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.deployer.spi.task.TaskStatus;

public class KubernetesTaskLauncher
extends AbstractKubernetesDeployer
implements TaskLauncher {
    @Autowired
    public KubernetesTaskLauncher(KubernetesDeployerProperties properties, KubernetesClient client) {
        this(properties, client, new DefaultContainerFactory(properties));
    }

    @Autowired
    public KubernetesTaskLauncher(KubernetesDeployerProperties properties, KubernetesClient client, ContainerFactory containerFactory) {
        this.properties = properties;
        this.client = client;
        this.containerFactory = containerFactory;
    }

    public String launch(AppDeploymentRequest request) {
        String appId = this.createDeploymentId(request);
        TaskStatus status = this.status(appId);
        if (!status.getState().equals((Object)LaunchState.unknown)) {
            throw new IllegalStateException("Task " + appId + " already exists with a state of " + status);
        }
        Map<String, String> idMap = this.createIdMap(appId, request);
        this.logger.debug((Object)String.format("Launching pod for task: %s", appId));
        try {
            HashMap<String, String> podLabelMap = new HashMap<String, String>();
            podLabelMap.put("task-name", request.getDefinition().getName());
            podLabelMap.put("role", "spring-app");
            PodSpec podSpec = this.createPodSpec(appId, request, null, true);
            if (this.properties.isCreateJob()) {
                this.launchJob(appId, podSpec, podLabelMap, idMap);
            } else {
                this.launchPod(appId, podSpec, podLabelMap, idMap);
            }
            return appId;
        }
        catch (RuntimeException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void cancel(String id) {
        this.logger.debug((Object)String.format("Cancelling task: %s", id));
        this.cleanup(id);
    }

    public void cleanup(String id) {
        try {
            boolean deleted;
            String workload;
            if (this.properties.isCreateJob()) {
                workload = "job";
                this.logger.debug((Object)String.format("Deleting %s for task: %s", workload, id));
                deleted = (Boolean)((ScalableResource)((NonNamespaceOperation)this.client.extensions().jobs().inNamespace(this.client.getNamespace())).withName(id)).delete();
            } else {
                workload = "pod";
                this.logger.debug((Object)String.format("Deleting %s for task: %s", workload, id));
                deleted = (Boolean)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.client.getNamespace())).withName(id)).delete();
            }
            if (deleted) {
                this.logger.debug((Object)String.format("Deleted %s successfully: %s", workload, id));
            } else {
                this.logger.debug((Object)String.format("Delete failed for %s: %s", workload, id));
            }
        }
        catch (RuntimeException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void destroy(String appName) {
        for (String id : this.getIdsForTaskName(appName)) {
            this.cleanup(id);
        }
    }

    public RuntimeEnvironmentInfo environmentInfo() {
        return super.createRuntimeEnvironmentInfo(TaskLauncher.class, this.getClass());
    }

    public TaskStatus status(String id) {
        TaskStatus status = this.buildTaskStatus(id);
        this.logger.debug((Object)String.format("Status for task: %s is %s", id, status));
        return status;
    }

    protected String createDeploymentId(AppDeploymentRequest request) {
        String name = request.getDefinition().getName();
        Hashids hashids = new Hashids(name, 0, "abcdefghijklmnopqrstuvwxyz1234567890");
        String hashid = hashids.encode(new long[]{System.currentTimeMillis()});
        String deploymentId = name + "-" + hashid;
        return deploymentId.replace('.', '-').toLowerCase();
    }

    private void launchPod(String appId, PodSpec podSpec, Map<String, String> labelMap, Map<String, String> idMap) {
        ((DoneablePod)((DoneablePod)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((DoneablePod)((NonNamespaceOperation)this.client.pods().inNamespace(this.client.getNamespace())).createNew()).withNewMetadata().withName(appId)).withLabels(labelMap)).addToLabels(idMap)).endMetadata()).withSpec(podSpec)).done();
    }

    private void launchJob(String appId, PodSpec podSpec, Map<String, String> podLabelMap, Map<String, String> idMap) {
        JobSpec jobSpec = ((JobSpecBuilder)new JobSpecBuilder().withTemplate(new PodTemplateSpec(((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withLabels(podLabelMap)).addToLabels(idMap)).build(), podSpec))).build();
        ((DoneableJob)((DoneableJob)((JobFluent.MetadataNested)((JobFluent.MetadataNested)((DoneableJob)((NonNamespaceOperation)this.client.extensions().jobs().inNamespace(this.client.getNamespace())).createNew()).withNewMetadata().withName(appId)).addToLabels(idMap)).endMetadata()).withSpec(jobSpec)).done();
    }

    private List<String> getIdsForTaskName(String taskName) {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            KubernetesResourceList resourceList = this.properties.isCreateJob() ? (KubernetesResourceList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.extensions().jobs().inNamespace(this.client.getNamespace())).withLabel("task-name", taskName)).list() : (KubernetesResourceList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(this.client.getNamespace())).withLabel("task-name", taskName)).list();
            for (HasMetadata hasMetadata : resourceList.getItems()) {
                ids.add(hasMetadata.getMetadata().getName());
            }
        }
        catch (KubernetesClientException kce) {
            this.logger.warn((Object)String.format("Failed to retrieve pods for task: %s", taskName), (Throwable)kce);
        }
        return ids;
    }

    TaskStatus buildTaskStatus(String id) {
        String phase;
        if (this.properties.isCreateJob()) {
            boolean succeeded;
            Job job = (Job)((ScalableResource)((NonNamespaceOperation)this.client.extensions().jobs().inNamespace(this.client.getNamespace())).withName(id)).get();
            if (job == null) {
                return new TaskStatus(id, LaunchState.unknown, new HashMap());
            }
            JobStatus jobStatus = job.getStatus();
            if (jobStatus == null) {
                return new TaskStatus(id, LaunchState.unknown, new HashMap());
            }
            boolean failed = jobStatus.getFailed() != null && jobStatus.getFailed() > 0;
            boolean bl = succeeded = jobStatus.getSucceeded() != null && jobStatus.getSucceeded() > 0;
            phase = failed ? "Failed" : (succeeded ? "Succeeded" : null);
        } else {
            Pod pod = (Pod)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.client.getNamespace())).withName(id)).get();
            if (pod == null) {
                return new TaskStatus(id, LaunchState.unknown, new HashMap());
            }
            PodStatus podStatus = pod.getStatus();
            if (podStatus == null) {
                return new TaskStatus(id, LaunchState.unknown, new HashMap());
            }
            phase = podStatus.getPhase();
        }
        if (phase != null) {
            if (phase.equals("Pending")) {
                return new TaskStatus(id, LaunchState.launching, new HashMap());
            }
            if (phase.equals("Failed")) {
                return new TaskStatus(id, LaunchState.failed, new HashMap());
            }
            if (phase.equals("Succeeded")) {
                return new TaskStatus(id, LaunchState.complete, new HashMap());
            }
            return new TaskStatus(id, LaunchState.running, new HashMap());
        }
        return new TaskStatus(id, LaunchState.launching, new HashMap());
    }
}

