/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.deployer.spi.app.AppInstanceStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.kubernetes.DefaultRunningPhaseDeploymentStateResolver;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.deployer.spi.kubernetes.RunningPhaseDeploymentStateResolver;

public class KubernetesAppInstanceStatus
implements AppInstanceStatus {
    private static Log logger = LogFactory.getLog(KubernetesAppInstanceStatus.class);
    private final Pod pod;
    private Service service;
    private KubernetesDeployerProperties properties;
    private ContainerStatus containerStatus;
    private RunningPhaseDeploymentStateResolver runningPhaseDeploymentStateResolver;

    public KubernetesAppInstanceStatus(Pod pod, Service service, KubernetesDeployerProperties properties) {
        this.pod = pod;
        this.service = service;
        this.properties = properties;
        this.containerStatus = pod != null && pod.getStatus().getContainerStatuses().size() == 1 ? (ContainerStatus)pod.getStatus().getContainerStatuses().get(0) : null;
        this.runningPhaseDeploymentStateResolver = new DefaultRunningPhaseDeploymentStateResolver(properties);
    }

    public void setRunningPhaseDeploymentStateResolver(RunningPhaseDeploymentStateResolver runningPhaseDeploymentStateResolver) {
        this.runningPhaseDeploymentStateResolver = runningPhaseDeploymentStateResolver;
    }

    public String getId() {
        return this.pod == null ? "N/A" : this.pod.getMetadata().getName();
    }

    public DeploymentState getState() {
        return this.pod != null && this.containerStatus != null ? this.mapState() : DeploymentState.unknown;
    }

    private DeploymentState mapState() {
        logger.debug((Object)String.format("%s - Phase [ %s ]", this.pod.getMetadata().getName(), this.pod.getStatus().getPhase()));
        logger.debug((Object)String.format("%s - ContainerStatus [ %s ]", this.pod.getMetadata().getName(), this.containerStatus));
        switch (this.pod.getStatus().getPhase()) {
            case "Pending": {
                return DeploymentState.deploying;
            }
            case "Running": {
                return this.runningPhaseDeploymentStateResolver.resolve(this.containerStatus);
            }
            case "Failed": {
                return DeploymentState.failed;
            }
            case "Unknown": {
                return DeploymentState.unknown;
            }
        }
        return DeploymentState.unknown;
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.pod != null) {
            result.put("pod.name", this.pod.getMetadata().getName());
            result.put("pod.startTime", this.pod.getStatus().getStartTime());
            result.put("pod.ip", this.pod.getStatus().getPodIP());
            result.put("host.ip", this.pod.getStatus().getHostIP());
            result.put("phase", this.pod.getStatus().getPhase());
            result.put("spring-app-id".replace('-', '.'), (String)this.pod.getMetadata().getLabels().get("spring-app-id"));
            result.put("spring-deployment-id".replace('-', '.'), (String)this.pod.getMetadata().getLabels().get("spring-deployment-id"));
        }
        if (this.service != null) {
            result.put("service.name", this.service.getMetadata().getName());
            if ("LoadBalancer".equals(this.service.getSpec().getType()) && this.service.getStatus() != null && this.service.getStatus().getLoadBalancer() != null && this.service.getStatus().getLoadBalancer().getIngress() != null && !this.service.getStatus().getLoadBalancer().getIngress().isEmpty()) {
                String externalIp = ((LoadBalancerIngress)this.service.getStatus().getLoadBalancer().getIngress().get(0)).getIp();
                result.put("service.external.ip", externalIp);
                List ports = this.service.getSpec().getPorts();
                int port = 0;
                if (ports != null && ports.size() > 0) {
                    port = ((ServicePort)ports.get(0)).getPort();
                    result.put("service.external.port", String.valueOf(port));
                }
                if (externalIp != null) {
                    result.put("url", "http://" + externalIp + (port > 0 && port != 80 ? ":" + port : ""));
                }
            }
        }
        if (this.containerStatus != null) {
            result.put("container.restartCount", "" + this.containerStatus.getRestartCount());
            if (this.containerStatus.getLastState() != null && this.containerStatus.getLastState().getTerminated() != null) {
                result.put("container.lastState.terminated.exitCode", "" + this.containerStatus.getLastState().getTerminated().getExitCode());
                result.put("container.lastState.terminated.reason", this.containerStatus.getLastState().getTerminated().getReason());
            }
            if (this.containerStatus.getState() != null && this.containerStatus.getState().getTerminated() != null) {
                result.put("container.state.terminated.exitCode", "" + this.containerStatus.getState().getTerminated().getExitCode());
                result.put("container.state.terminated.reason", this.containerStatus.getState().getTerminated().getReason());
            }
        }
        return result;
    }
}

