/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.kubernetes;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.cloud.deployer.kubernetes")
public class KubernetesDeployerProperties {
    private static String KUBERNETES_NAMESPACE = System.getenv("KUBERNETES_NAMESPACE") != null ? System.getenv("KUBERNETES_NAMESPACE") : "default";
    private String namespace = KUBERNETES_NAMESPACE;
    private String imagePullSecret;
    private int livenessProbeDelay = 10;
    private int livenessProbePeriod = 60;
    private int livenessProbeTimeout = 2;
    private String livenessProbePath = "/health";
    private int readinessProbeDelay = 10;
    private int readinessProbePeriod = 10;
    private int readinessProbeTimeout = 2;
    private String readinessProbePath = "/info";
    private String memory = "512Mi";
    private String cpu = "500m";
    private String[] environmentVariables = new String[0];
    private boolean createLoadBalancer = false;
    private int minutesToWaitForLoadBalancer = 5;
    private int maxTerminatedErrorRestarts = 2;
    private int maxCrashLoopBackOffRestarts = 4;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getImagePullSecret() {
        return this.imagePullSecret;
    }

    public void setImagePullSecret(String imagePullSecret) {
        this.imagePullSecret = imagePullSecret;
    }

    public int getLivenessProbeDelay() {
        return this.livenessProbeDelay;
    }

    public void setLivenessProbeDelay(int livenessProbeDelay) {
        this.livenessProbeDelay = livenessProbeDelay;
    }

    public int getLivenessProbePeriod() {
        return this.livenessProbePeriod;
    }

    public void setLivenessProbePeriod(int livenessProbePeriod) {
        this.livenessProbePeriod = livenessProbePeriod;
    }

    public int getLivenessProbeTimeout() {
        return this.livenessProbeTimeout;
    }

    public void setLivenessProbeTimeout(int livenessProbeTimeout) {
        this.livenessProbeTimeout = livenessProbeTimeout;
    }

    public String getLivenessProbePath() {
        return this.livenessProbePath;
    }

    public void setLivenessProbePath(String livenessProbePath) {
        this.livenessProbePath = livenessProbePath;
    }

    public int getReadinessProbeDelay() {
        return this.readinessProbeDelay;
    }

    public void setReadinessProbeDelay(int readinessProbeDelay) {
        this.readinessProbeDelay = readinessProbeDelay;
    }

    public int getReadinessProbePeriod() {
        return this.readinessProbePeriod;
    }

    public void setReadinessProbePeriod(int readinessProbePeriod) {
        this.readinessProbePeriod = readinessProbePeriod;
    }

    public int getReadinessProbeTimeout() {
        return this.readinessProbeTimeout;
    }

    public void setReadinessProbeTimeout(int readinessProbeTimeout) {
        this.readinessProbeTimeout = readinessProbeTimeout;
    }

    public String getReadinessProbePath() {
        return this.readinessProbePath;
    }

    public void setReadinessProbePath(String readinessProbePath) {
        this.readinessProbePath = readinessProbePath;
    }

    public String getMemory() {
        return this.memory;
    }

    public void setMemory(String memory) {
        this.memory = memory;
    }

    public String getCpu() {
        return this.cpu;
    }

    public void setCpu(String cpu) {
        this.cpu = cpu;
    }

    public String[] getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(String[] environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public boolean isCreateLoadBalancer() {
        return this.createLoadBalancer;
    }

    public void setCreateLoadBalancer(boolean createLoadBalancer) {
        this.createLoadBalancer = createLoadBalancer;
    }

    public int getMinutesToWaitForLoadBalancer() {
        return this.minutesToWaitForLoadBalancer;
    }

    public void setMinutesToWaitForLoadBalancer(int minutesToWaitForLoadBalancer) {
        this.minutesToWaitForLoadBalancer = minutesToWaitForLoadBalancer;
    }

    public int getMaxTerminatedErrorRestarts() {
        return this.maxTerminatedErrorRestarts;
    }

    public void setMaxTerminatedErrorRestarts(int maxTerminatedErrorRestarts) {
        this.maxTerminatedErrorRestarts = maxTerminatedErrorRestarts;
    }

    public int getMaxCrashLoopBackOffRestarts() {
        return this.maxCrashLoopBackOffRestarts;
    }

    public void setMaxCrashLoopBackOffRestarts(int maxCrashLoopBackOffRestarts) {
        this.maxCrashLoopBackOffRestarts = maxCrashLoopBackOffRestarts;
    }
}

