/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import java.time.Duration;
import java.util.List;
import org.cloudfoundry.logcache.v1.Envelope;
import org.cloudfoundry.logcache.v1.Log;
import org.cloudfoundry.logcache.v1.LogCacheClient;
import org.cloudfoundry.logcache.v1.ReadRequest;
import org.cloudfoundry.logcache.v1.ReadResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

public class ApplicationLogAccessor {
    private static final int MAX_LOG_LIMIT = 1000;
    private static final Logger logger = LoggerFactory.getLogger(ApplicationLogAccessor.class);
    private final LogCacheClient logCacheClient;

    public ApplicationLogAccessor(LogCacheClient logCacheClient) {
        Assert.notNull((Object)logCacheClient, (String)"logCacheClient must not be null");
        this.logCacheClient = logCacheClient;
    }

    public String getLog(String deploymentId, Duration apiTimeout) {
        logger.debug("Retrieving log for deploymentId:{} with apiTimeout:{}", (Object)deploymentId, (Object)apiTimeout);
        Assert.hasText((String)deploymentId, (String)"id must have text and not null");
        Assert.notNull((Object)apiTimeout, (String)"apiTimeout must not be null");
        StringBuilder stringBuilder = new StringBuilder();
        ReadRequest request = ReadRequest.builder().sourceId(deploymentId).limit(Integer.valueOf(1000)).descending(Boolean.valueOf(true)).build();
        List logs = (List)this.logCacheClient.read(request).flatMapMany(this::responseToEnvelope).collectList().block(apiTimeout);
        if (logs == null) {
            return "";
        }
        logs.forEach(log -> {
            stringBuilder.append(log.getPayloadAsText());
            stringBuilder.append(System.lineSeparator());
        });
        String[] lines = stringBuilder.toString().split("\n");
        StringBuilder stringBuilderReconstruct = new StringBuilder();
        for (int i = lines.length - 1; i >= 0; --i) {
            stringBuilderReconstruct.append(lines[i]);
            if (i <= 0) continue;
            stringBuilderReconstruct.append("\n");
        }
        return stringBuilderReconstruct.toString();
    }

    private Flux<Log> responseToEnvelope(ReadResponse response) {
        return Flux.fromIterable((Iterable)response.getEnvelopes().getBatch()).filter(envelope -> envelope.getLog() != null).map(Envelope::getLog);
    }
}

