/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import com.github.zafarkhaja.semver.Version;
import java.time.Duration;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.info.GetInfoRequest;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.DefaultCloudFoundryOperations;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.DefaultConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.ReactorCloudFoundryClient;
import org.cloudfoundry.reactor.tokenprovider.PasswordGrantTokenProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.cloudfoundry.AppNameGenerator;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryActuatorTemplate;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryAppDeployer;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryAppNameGenerator;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryConnectionProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryPlatformSpecificInfo;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryTaskLauncher;
import org.springframework.cloud.deployer.spi.cloudfoundry.DurationConverter;
import org.springframework.cloud.deployer.spi.cloudfoundry.UnsupportedVersionTaskLauncher;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.deployer.spi.util.RuntimeVersionUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties
@AutoConfigureOrder(value=-2147483648)
public class CloudFoundryDeployerAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CloudFoundryDeployerAutoConfiguration.class);
    @Autowired
    private EarlyConnectionConfiguration connectionConfiguration;

    @Bean
    @ConditionalOnMissingBean
    public CloudFoundryOperations cloudFoundryOperations(CloudFoundryClient cloudFoundryClient, CloudFoundryConnectionProperties properties) {
        return DefaultCloudFoundryOperations.builder().cloudFoundryClient(cloudFoundryClient).organization(properties.getOrg()).space(properties.getSpace()).build();
    }

    private RuntimeEnvironmentInfo runtimeEnvironmentInfo(Class spiClass, Class implementationClass) {
        CloudFoundryClient client = this.connectionConfiguration.cloudFoundryClient(this.connectionConfiguration.connectionContext(this.connectionConfiguration.cloudFoundryConnectionProperties()), this.connectionConfiguration.tokenProvider(this.connectionConfiguration.cloudFoundryConnectionProperties()));
        Version version = this.connectionConfiguration.version(client);
        return new CloudFoundryPlatformSpecificInfo(new RuntimeEnvironmentInfo.Builder()).apiEndpoint(this.connectionConfiguration.cloudFoundryConnectionProperties().getUrl().toString()).org(this.connectionConfiguration.cloudFoundryConnectionProperties().getOrg()).space(this.connectionConfiguration.cloudFoundryConnectionProperties().getSpace()).builder().implementationName(implementationClass.getSimpleName()).spiClass(spiClass).implementationVersion(RuntimeVersionUtils.getVersion(CloudFoundryAppDeployer.class)).platformType("Cloud Foundry").platformClientVersion(RuntimeVersionUtils.getVersion(client.getClass())).platformApiVersion(version.toString()).platformHostVersion("unknown").build();
    }

    @Bean
    @ConditionalOnMissingBean(value={AppDeployer.class})
    public AppDeployer appDeployer(CloudFoundryOperations operations, AppNameGenerator applicationNameGenerator) {
        return new CloudFoundryAppDeployer(applicationNameGenerator, this.connectionConfiguration.appDeploymentProperties(), operations, this.runtimeEnvironmentInfo(AppDeployer.class, CloudFoundryAppDeployer.class));
    }

    @Bean
    CloudFoundryActuatorTemplate actuatorOperations(RestTemplate actuatorRestTemplate, AppDeployer appDeployer) {
        return new CloudFoundryActuatorTemplate(actuatorRestTemplate, appDeployer, this.connectionConfiguration.appDeploymentProperties().getAppAdmin());
    }

    @Bean
    RestTemplate actuatorRestTemplate() {
        return new RestTemplate();
    }

    @Bean
    @ConditionalOnMissingBean(value={AppNameGenerator.class})
    public AppNameGenerator appDeploymentCustomizer() {
        return new CloudFoundryAppNameGenerator(this.connectionConfiguration.appDeploymentProperties());
    }

    @Bean
    @ConditionalOnMissingBean(value={TaskLauncher.class})
    public TaskLauncher taskLauncher(CloudFoundryClient client, CloudFoundryOperations operations, Version version) {
        if (version.greaterThanOrEqualTo(UnsupportedVersionTaskLauncher.MINIMUM_SUPPORTED_VERSION)) {
            RuntimeEnvironmentInfo runtimeEnvironmentInfo = this.runtimeEnvironmentInfo(TaskLauncher.class, CloudFoundryTaskLauncher.class);
            return new CloudFoundryTaskLauncher(client, this.connectionConfiguration.taskDeploymentProperties(), operations, runtimeEnvironmentInfo);
        }
        RuntimeEnvironmentInfo runtimeEnvironmentInfo = this.runtimeEnvironmentInfo(TaskLauncher.class, UnsupportedVersionTaskLauncher.class);
        return new UnsupportedVersionTaskLauncher(version, runtimeEnvironmentInfo);
    }

    @Bean
    @ConfigurationPropertiesBinding
    public DurationConverter durationConverter() {
        return new DurationConverter();
    }

    @Configuration
    @EnableConfigurationProperties
    public static class EarlyConnectionConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"appDeploymentProperties"})
        public CloudFoundryDeploymentProperties appDeploymentProperties() {
            return this.defaultSharedDeploymentProperties();
        }

        @Bean
        @ConditionalOnMissingBean(name={"taskDeploymentProperties"})
        public CloudFoundryDeploymentProperties taskDeploymentProperties() {
            return this.defaultSharedDeploymentProperties();
        }

        @Bean
        @ConfigurationProperties(prefix="spring.cloud.deployer.cloudfoundry")
        public CloudFoundryDeploymentProperties defaultSharedDeploymentProperties() {
            return new CloudFoundryDeploymentProperties();
        }

        @Bean
        @ConditionalOnMissingBean
        public Version version(CloudFoundryClient client) {
            return (Version)client.info().get(GetInfoRequest.builder().build()).map(response -> Version.valueOf((String)response.getApiVersion())).doOnError(e -> {
                throw new RuntimeException("Bad credentials connecting to Cloud Foundry.", (Throwable)e);
            }).doOnNext(version -> logger.info("Connecting to Cloud Foundry with API Version {}", version)).block(Duration.ofSeconds(this.appDeploymentProperties().getApiTimeout()));
        }

        @Bean
        @ConditionalOnMissingBean
        public CloudFoundryClient cloudFoundryClient(ConnectionContext connectionContext, TokenProvider tokenProvider) {
            return ReactorCloudFoundryClient.builder().connectionContext(connectionContext).tokenProvider(tokenProvider).build();
        }

        @Bean
        @ConditionalOnMissingBean
        public TokenProvider tokenProvider(CloudFoundryConnectionProperties properties) {
            PasswordGrantTokenProvider.Builder tokenProviderBuilder = PasswordGrantTokenProvider.builder().username(properties.getUsername()).password(properties.getPassword()).loginHint(properties.getLoginHint());
            if (StringUtils.hasText((String)properties.getClientId())) {
                tokenProviderBuilder.clientId(properties.getClientId());
            }
            if (StringUtils.hasText((String)properties.getClientSecret())) {
                tokenProviderBuilder.clientSecret(properties.getClientSecret());
            }
            return tokenProviderBuilder.build();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConfigurationProperties(prefix="spring.cloud.deployer.cloudfoundry")
        public CloudFoundryConnectionProperties cloudFoundryConnectionProperties() {
            return new CloudFoundryConnectionProperties();
        }

        @Bean
        @ConditionalOnMissingBean
        public ConnectionContext connectionContext(CloudFoundryConnectionProperties properties) {
            return DefaultConnectionContext.builder().apiHost(properties.getUrl().getHost()).skipSslValidation(properties.isSkipSslValidation()).build();
        }
    }
}

