/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.cloudfoundry;

import com.github.zafarkhaja.semver.Version;
import java.time.Duration;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.info.GetInfoRequest;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.DefaultCloudFoundryOperations;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.DefaultConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.ReactorCloudFoundryClient;
import org.cloudfoundry.reactor.tokenprovider.PasswordGrantTokenProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.cloudfoundry.AppNameGenerator;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundry2620AndEarlierTaskLauncher;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundry2630AndLaterTaskLauncher;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryAppDeployer;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryAppNameGenerator;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryConnectionProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.DurationConverter;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
@AutoConfigureOrder(value=-2147483648)
public class CloudFoundryDeployerAutoConfiguration {
    private static final Version CF_TASKS_INFLECTION_POINT = Version.forIntegers((int)2, (int)63, (int)0);
    private static final Logger logger = LoggerFactory.getLogger(CloudFoundryDeployerAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(name={"appDeploymentProperties"})
    public CloudFoundryDeploymentProperties appDeploymentProperties() {
        return this.defaultSharedDeploymentProperties();
    }

    @Bean
    @ConditionalOnMissingBean(name={"taskDeploymentProperties"})
    public CloudFoundryDeploymentProperties taskDeploymentProperties() {
        return this.defaultSharedDeploymentProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="spring.cloud.deployer.cloudfoundry")
    public CloudFoundryDeploymentProperties defaultSharedDeploymentProperties() {
        return new CloudFoundryDeploymentProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix="spring.cloud.deployer.cloudfoundry")
    public CloudFoundryConnectionProperties cloudFoundryConnectionProperties() {
        return new CloudFoundryConnectionProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectionContext connectionContext(CloudFoundryConnectionProperties properties) {
        return DefaultConnectionContext.builder().apiHost(properties.getUrl().getHost()).skipSslValidation(properties.isSkipSslValidation()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public TokenProvider tokenProvider(CloudFoundryConnectionProperties properties) {
        return PasswordGrantTokenProvider.builder().username(properties.getUsername()).password(properties.getPassword()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public CloudFoundryClient cloudFoundryClient(ConnectionContext connectionContext, TokenProvider tokenProvider) {
        return ReactorCloudFoundryClient.builder().connectionContext(connectionContext).tokenProvider(tokenProvider).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public CloudFoundryOperations cloudFoundryOperations(CloudFoundryClient cloudFoundryClient, CloudFoundryConnectionProperties properties) {
        return DefaultCloudFoundryOperations.builder().cloudFoundryClient(cloudFoundryClient).organization(properties.getOrg()).space(properties.getSpace()).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={AppDeployer.class})
    public AppDeployer appDeployer(CloudFoundryOperations operations, CloudFoundryClient client, AppNameGenerator applicationNameGenerator) {
        return new CloudFoundryAppDeployer(applicationNameGenerator, client, this.appDeploymentProperties(), operations);
    }

    @Bean
    @ConditionalOnMissingBean(value={AppNameGenerator.class})
    public AppNameGenerator appDeploymentCustomizer() {
        return new CloudFoundryAppNameGenerator(this.appDeploymentProperties());
    }

    @Bean
    @ConditionalOnMissingBean(value={TaskLauncher.class})
    public TaskLauncher taskLauncher(CloudFoundryClient client, CloudFoundryConnectionProperties connectionProperties, CloudFoundryOperations operations) {
        return (TaskLauncher)client.info().get(GetInfoRequest.builder().build()).map(response -> Version.valueOf((String)response.getApiVersion())).doOnNext(version -> logger.info("Connecting to Cloud Foundry with API Version {}", version)).map(version -> {
            if (version.greaterThanOrEqualTo(CF_TASKS_INFLECTION_POINT)) {
                return new CloudFoundry2630AndLaterTaskLauncher(client, this.taskDeploymentProperties(), operations);
            }
            return new CloudFoundry2620AndEarlierTaskLauncher(client, this.taskDeploymentProperties(), operations, connectionProperties.getSpace());
        }).block(Duration.ofSeconds(this.taskDeploymentProperties().getApiTimeout()));
    }

    @Bean
    @ConfigurationPropertiesBinding
    public DurationConverter durationConverter() {
        return new DurationConverter();
    }
}

