/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.autoconfigure.local;

import java.io.File;
import java.util.HashMap;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.cloud.dataflow.server.config.DataFlowControllerAutoConfiguration;
import org.springframework.cloud.deployer.resource.docker.DockerResourceLoader;
import org.springframework.cloud.deployer.resource.maven.MavenProperties;
import org.springframework.cloud.deployer.resource.maven.MavenResourceLoader;
import org.springframework.cloud.deployer.resource.support.DelegatingResourceLoader;
import org.springframework.cloud.deployer.resource.support.LRUCleaningResourceLoaderBeanPostProcessor;
import org.springframework.cloud.deployer.spi.local.LocalDeployerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={DataFlowControllerAutoConfiguration.class})
public class LocalDataFlowServerAutoConfiguration {
    @Bean
    public DelegatingResourceLoader delegatingResourceLoader(MavenProperties mavenProperties) {
        DockerResourceLoader dockerLoader = new DockerResourceLoader();
        MavenResourceLoader mavenResourceLoader = new MavenResourceLoader(mavenProperties);
        HashMap<String, Object> loaders = new HashMap<String, Object>();
        loaders.put("docker", dockerLoader);
        loaders.put("maven", mavenResourceLoader);
        return new DelegatingResourceLoader(loaders);
    }

    @Bean
    public LRUCleaningResourceLoaderBeanPostProcessor lruCleaningResourceLoaderInstaller(LocalDeployerProperties localDeployerProperties, MavenProperties mavenProperties) {
        File repositoryCache = new File(mavenProperties.getLocalRepository());
        float fRatio = (float)localDeployerProperties.getFreeDiskSpacePercentage() / 100.0f;
        return new LRUCleaningResourceLoaderBeanPostProcessor(fRatio, repositoryCache);
    }
}

