/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.cloudfoundry.config;

import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.config.java.AbstractCloudConfig;
import org.springframework.cloud.dataflow.server.cloudfoundry.config.CloudFoundryServerConfigurationProperties;
import org.springframework.cloud.service.PooledServiceConnectorConfig;
import org.springframework.cloud.service.relational.DataSourceConfig;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Profile(value={"cloud"})
@Configuration
public class DataSourceCloudConfig
extends AbstractCloudConfig {
    @Bean
    public DataSource scdfCloudDataSource(CloudFoundryServerConfigurationProperties cloudFoundryServerConfigurationProperties) {
        PooledServiceConnectorConfig.PoolConfig poolConfig = new PooledServiceConnectorConfig.PoolConfig(cloudFoundryServerConfigurationProperties.getMaxPoolSize(), cloudFoundryServerConfigurationProperties.getMaxWaitTime());
        DataSourceConfig dbConfig = new DataSourceConfig(poolConfig, null);
        return this.connectionFactory().dataSource(dbConfig);
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.cloud.dataflow.features", name={"analytics-enabled"}, matchIfMissing=true)
    public RedisConnectionFactory redisFactory() {
        return this.connectionFactory().redisConnectionFactory();
    }
}

