/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.cloudfoundry.resource;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.resource.support.DelegatingResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.FileSystemUtils;

class LRUCleaningResourceLoader
extends DelegatingResourceLoader {
    private static final Logger logger = LoggerFactory.getLogger(LRUCleaningResourceLoader.class);
    private final File repositoryCache;
    private final ResourceLoader delegate;
    private final Map<File, Void> lruCache = new LRUCache();
    private final float targetFreeSpaceRatio;

    public LRUCleaningResourceLoader(ResourceLoader delegate, float targetFreeSpaceRatio, File repositoryCache) {
        Assert.notNull((Object)delegate, (String)"delegate cannot be null");
        Assert.isTrue((0.0f <= targetFreeSpaceRatio && targetFreeSpaceRatio <= 1.0f ? 1 : 0) != 0, (String)"targetFreeSpaceRatio should between [0,1] inclusive.");
        this.delegate = delegate;
        this.targetFreeSpaceRatio = targetFreeSpaceRatio;
        this.repositoryCache = repositoryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResource(String location) {
        Resource resource = this.delegate.getResource(location);
        try {
            File file = resource.getFile();
            Map<File, Void> map = this.lruCache;
            synchronized (map) {
                this.lruCache.put(file, null);
            }
            return resource;
        }
        catch (IOException e) {
            logger.debug("{} is not stored on the local filesystem, skipping", (Object)resource);
            return resource;
        }
    }

    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    private boolean shouldDelete(File file) {
        boolean shouldDelete = (float)file.getFreeSpace() / (float)file.getTotalSpace() < this.targetFreeSpaceRatio;
        logger.trace("Should Delete {} ? [{}]", (Object)file, (Object)shouldDelete);
        return shouldDelete;
    }

    private class LRUCache
    extends LinkedHashMap<File, Void> {
        LRUCache() {
            super(5, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<File, Void> eldest) {
            long lastTotalSpaceSeen = -1L;
            Iterator it = this.keySet().iterator();
            while (it.hasNext()) {
                File file = (File)it.next();
                if (file.getTotalSpace() != lastTotalSpaceSeen) {
                    String percentFreeSpace = String.format(Locale.US, "%.2f", Float.valueOf(100.0f * (float)file.getFreeSpace() / (float)file.getTotalSpace()));
                    logger.info("Free Disk Space = {}%, Target Free Space >{}%", (Object)percentFreeSpace, (Object)String.format(Locale.US, "%.2f", Float.valueOf(100.0f * LRUCleaningResourceLoader.this.targetFreeSpaceRatio)));
                    lastTotalSpaceSeen = file.getTotalSpace();
                }
                logger.debug("Looking at LRU entry {}, Free Space = {} bytes, Total Space = {} bytes", new Object[]{file, file.getFreeSpace(), file.getTotalSpace()});
                if (LRUCleaningResourceLoader.this.shouldDelete(file) && it.hasNext()) {
                    this.cleanup(file);
                    it.remove();
                    continue;
                }
                logger.debug("No action taken for LRU entry {}", (Object)file);
            }
            return false;
        }

        private void cleanup(File file) {
            if (LRUCleaningResourceLoader.this.repositoryCache != null && file.getPath().startsWith(LRUCleaningResourceLoader.this.repositoryCache.getPath())) {
                boolean success = FileSystemUtils.deleteRecursively((File)file.getParentFile());
                logger.info("[{}] Deleting {} parent directory to regain free disk space.", (Object)(success ? "SUCCESS" : "FAILED"), (Object)file);
            } else {
                boolean success = file.delete();
                logger.info("[{}] Deleting {} to regain free disk space", (Object)(success ? "SUCCESS" : "FAILED"), (Object)file);
            }
        }
    }
}

