/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.server.cloudfoundry.config;

import java.io.File;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.dataflow.server.cloudfoundry.config.CloudFoundryServerConfigurationProperties;
import org.springframework.cloud.dataflow.server.cloudfoundry.resource.LRUCleaningResourceLoaderBeanPostProcessor;
import org.springframework.cloud.deployer.resource.maven.MavenProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Hooks;

@Configuration
public class CloudFoundryDataFlowServerConfiguration {
    @Bean
    @ConfigurationProperties(prefix="spring.cloud.deployer.cloudfoundry.stream")
    public CloudFoundryDeploymentProperties appDeploymentProperties() {
        return new CloudFoundryDeploymentProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="spring.cloud.deployer.cloudfoundry.task")
    public CloudFoundryDeploymentProperties taskDeploymentProperties() {
        return new CloudFoundryDeploymentProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="spring.cloud.dataflow.server.cloudfoundry")
    public CloudFoundryServerConfigurationProperties cloudFoundryServerConfigurationProperties() {
        return new CloudFoundryServerConfigurationProperties();
    }

    @Bean
    public LRUCleaningResourceLoaderBeanPostProcessor lruCleaningResourceLoaderInstaller(CloudFoundryServerConfigurationProperties serverConfiguration, MavenProperties mavenProperties) {
        File repositoryCache = new File(mavenProperties.getLocalRepository());
        float fRatio = (float)serverConfiguration.getFreeDiskSpacePercentage() / 100.0f;
        return new LRUCleaningResourceLoaderBeanPostProcessor(fRatio, repositoryCache);
    }

    @PostConstruct
    public void afterPropertiesSet() {
        if (this.cloudFoundryServerConfigurationProperties().isDebugReactor()) {
            Hooks.onOperator(op -> op.operatorStacktrace());
        }
    }
}

