/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.cloud.dataflow.rest.resource.AppRegistrationResource;
import org.springframework.cloud.dataflow.schema.AppBootSchemaVersion;
import org.springframework.hateoas.PagedModel;

public class DetailedAppRegistrationResource
extends AppRegistrationResource {
    private final List<ConfigurationMetadataProperty> options = new ArrayList<ConfigurationMetadataProperty>();
    private String shortDescription;
    private final Set<String> inboundPortNames = new HashSet<String>();
    private final Set<String> outboundPortNames = new HashSet<String>();
    private final Map<String, Set<String>> optionGroups = new HashMap<String, Set<String>>();

    protected DetailedAppRegistrationResource() {
    }

    public DetailedAppRegistrationResource(String name, String type, String version, String coordinates, AppBootSchemaVersion bootVersion, Boolean isDefault) {
        super(name, type, version, coordinates, bootVersion, isDefault);
    }

    public DetailedAppRegistrationResource(AppRegistrationResource resource) {
        super(resource.getName(), resource.getType(), resource.getVersion(), resource.getUri(), resource.getBootVersion(), resource.getDefaultVersion());
    }

    public void addOption(ConfigurationMetadataProperty option) {
        this.options.add(option);
    }

    public List<ConfigurationMetadataProperty> getOptions() {
        return this.options;
    }

    public void addInboundPortName(String inboundPortName) {
        this.inboundPortNames.add(inboundPortName);
    }

    public void addOutboundPortName(String outboundPortName) {
        this.outboundPortNames.add(outboundPortName);
    }

    public Set<String> getInboundPortNames() {
        return this.inboundPortNames;
    }

    public Set<String> getOutboundPortNames() {
        return this.outboundPortNames;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public Map<String, Set<String>> getOptionGroups() {
        return this.optionGroups;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public static class Page
    extends PagedModel<DetailedAppRegistrationResource> {
    }
}

