/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock.restdocs;

import com.github.tomakehurst.wiremock.client.RemoteMappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.snippet.Snippet;

public class WireMockSnippet
implements Snippet {
    private String snippetName = "stubs";
    private Set<String> headerBlackList = new HashSet<String>(Arrays.asList("host", "content-length"));
    private Set<String> jsonPaths = new LinkedHashSet<String>();
    private MediaType contentType;
    private StubMapping stubMapping;
    private boolean hasJsonBodyRequestToMatch = false;

    public void document(Operation operation) throws IOException {
        this.extractMatchers(operation);
        if (this.stubMapping == null) {
            this.stubMapping = this.request(operation).willReturn(this.response(operation)).build();
        }
        String json = Json.write((Object)this.stubMapping);
        RestDocumentationContext context = (RestDocumentationContext)operation.getAttributes().get(RestDocumentationContext.class.getName());
        File output = new File(context.getOutputDirectory(), this.snippetName + "/" + operation.getName() + ".json");
        output.getParentFile().mkdirs();
        try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(output));){
            ((Writer)writer).append(json);
        }
    }

    private void extractMatchers(Operation operation) {
        Set jsonPaths;
        this.stubMapping = (StubMapping)operation.getAttributes().get("contract.stubMapping");
        if (this.stubMapping != null) {
            return;
        }
        this.jsonPaths = jsonPaths = (Set)operation.getAttributes().get("contract.jsonPaths");
        this.contentType = (MediaType)operation.getAttributes().get("contract.contentType");
        if (this.contentType == null) {
            this.hasJsonBodyRequestToMatch = this.hasJsonContentType(operation);
        }
    }

    private boolean hasJsonContentType(Operation operation) {
        return operation.getRequest().getHeaders().getContentType() != null && operation.getRequest().getHeaders().getContentType().isCompatibleWith(MediaType.APPLICATION_JSON);
    }

    private ResponseDefinitionBuilder response(Operation operation) {
        return WireMock.aResponse().withHeaders(this.responseHeaders(operation)).withBody(operation.getResponse().getContentAsString()).withStatus(operation.getResponse().getStatus().value());
    }

    private RemoteMappingBuilder<?, ?> request(Operation operation) {
        return this.requestHeaders(this.requestBuilder(operation), operation);
    }

    private RemoteMappingBuilder<?, ?> requestHeaders(RemoteMappingBuilder<?, ?> request, Operation operation) {
        HttpHeaders headers = operation.getRequest().getHeaders();
        for (String name : headers.keySet()) {
            if (this.headerBlackList.contains(name.toLowerCase()) || "content-type".equalsIgnoreCase(name) && this.contentType != null) continue;
            request = request.withHeader(name, WireMock.equalTo((String)headers.getFirst(name)));
        }
        if (this.contentType != null) {
            request = request.withHeader("Content-Type", WireMock.matching((String)(Pattern.quote(this.contentType.toString()) + ".*")));
        }
        return request;
    }

    private RemoteMappingBuilder<?, ?> requestBuilder(Operation operation) {
        switch (operation.getRequest().getMethod()) {
            case DELETE: {
                return WireMock.delete((UrlPattern)this.requestPattern(operation));
            }
            case POST: {
                return this.bodyPattern(WireMock.post((UrlPattern)this.requestPattern(operation)), operation.getRequest().getContentAsString());
            }
            case PUT: {
                return this.bodyPattern(WireMock.put((UrlPattern)this.requestPattern(operation)), operation.getRequest().getContentAsString());
            }
            case PATCH: {
                return this.bodyPattern(WireMock.patch((UrlPattern)this.requestPattern(operation)), operation.getRequest().getContentAsString());
            }
            case GET: {
                return WireMock.get((UrlPattern)this.requestPattern(operation));
            }
            case HEAD: {
                return WireMock.head((UrlPattern)this.requestPattern(operation));
            }
            case OPTIONS: {
                return WireMock.options((UrlPattern)this.requestPattern(operation));
            }
            case TRACE: {
                return WireMock.trace((UrlPattern)this.requestPattern(operation));
            }
        }
        throw new UnsupportedOperationException("Unsupported method type: " + operation.getRequest().getMethod());
    }

    private RemoteMappingBuilder<?, ?> bodyPattern(RemoteMappingBuilder<?, ?> builder, String content) {
        if (this.jsonPaths != null) {
            for (String jsonPath : this.jsonPaths) {
                builder.withRequestBody(WireMock.matchingJsonPath((String)jsonPath));
            }
        } else if (this.hasJsonBodyRequestToMatch) {
            builder.withRequestBody(WireMock.equalToJson((String)content));
        } else {
            builder.withRequestBody(WireMock.equalTo((String)content));
        }
        return builder;
    }

    private UrlPattern requestPattern(Operation operation) {
        return WireMock.urlEqualTo((String)operation.getRequest().getUri().getPath());
    }

    private com.github.tomakehurst.wiremock.http.HttpHeaders responseHeaders(Operation operation) {
        HttpHeaders headers = operation.getResponse().getHeaders();
        com.github.tomakehurst.wiremock.http.HttpHeaders result = new com.github.tomakehurst.wiremock.http.HttpHeaders();
        for (String name : headers.keySet()) {
            if (this.headerBlackList.contains(name.toLowerCase())) continue;
            result = result.plus(new HttpHeader[]{new HttpHeader(name, (Collection)headers.get((Object)name))});
        }
        return result;
    }
}

