/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.dsl.wiremock;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import groovy.lang.GString;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.Body;
import org.springframework.cloud.contract.spec.internal.BodyMatcher;
import org.springframework.cloud.contract.spec.internal.BodyMatchers;
import org.springframework.cloud.contract.spec.internal.ClientDslProperty;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.spec.internal.MatchingStrategy;
import org.springframework.cloud.contract.spec.internal.MatchingType;
import org.springframework.cloud.contract.spec.internal.NamedProperty;
import org.springframework.cloud.contract.spec.internal.OptionalProperty;
import org.springframework.cloud.contract.spec.internal.PathBodyMatcher;
import org.springframework.cloud.contract.spec.internal.QueryParameters;
import org.springframework.cloud.contract.spec.internal.RegexPatterns;
import org.springframework.cloud.contract.spec.internal.RegexProperty;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.spec.internal.Url;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.converter.YamlContractConverter;
import org.springframework.cloud.contract.verifier.dsl.ContractVerifierMetadata;
import org.springframework.cloud.contract.verifier.dsl.wiremock.BaseWireMockStubStrategy;
import org.springframework.cloud.contract.verifier.dsl.wiremock.XPathBodyMatcherToWireMockValuePatternConverter;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.ContentType;
import org.springframework.cloud.contract.verifier.util.ContentUtils;
import org.springframework.cloud.contract.verifier.util.JsonPaths;
import org.springframework.cloud.contract.verifier.util.JsonToJsonPathsConverter;
import org.springframework.cloud.contract.verifier.util.MapConverter;
import org.springframework.cloud.contract.verifier.util.MethodBufferingJsonVerifiable;
import org.springframework.cloud.contract.verifier.util.RegexpBuilders;
import org.springframework.cloud.contract.verifier.util.xml.XmlToXPathsConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.json.JsonMapper;

class WireMockRequestStubStrategy
extends BaseWireMockStubStrategy {
    private final Request request;
    private final ContentType contentType;

    WireMockRequestStubStrategy(Contract groovyDsl, SingleContractMetadata singleContractMetadata) {
        super(groovyDsl);
        this.request = groovyDsl.getRequest();
        this.contentType = this.contentType(singleContractMetadata);
    }

    protected ContentType contentType(SingleContractMetadata singleContractMetadata) {
        return singleContractMetadata.getEvaluatedInputStubContentType();
    }

    RequestPattern buildClientRequestContent() {
        if (this.request == null) {
            return null;
        }
        RequestPatternBuilder requestPatternBuilder = this.appendMethodAndUrl();
        this.appendCookies(requestPatternBuilder);
        this.appendHeaders(requestPatternBuilder);
        this.appendQueryParameters(requestPatternBuilder);
        this.appendBody(requestPatternBuilder);
        this.appendMultipart(requestPatternBuilder);
        return requestPatternBuilder.build();
    }

    private void appendBody(RequestPatternBuilder requestPatternBuilder) {
        if (this.contract.getMetadata().containsKey("verifier")) {
            ContractVerifierMetadata metadata = ContractVerifierMetadata.fromMetadata(this.contract.getMetadata());
            this.appendSpringCloudContractMatcher(metadata, requestPatternBuilder);
            if (!StringUtils.hasLength((String)metadata.getTool())) {
                this.doAppendBody(requestPatternBuilder);
            }
        } else {
            this.doAppendBody(requestPatternBuilder);
        }
    }

    private void appendSpringCloudContractMatcher(ContractVerifierMetadata metadata, RequestPatternBuilder requestPatternBuilder) {
        Parameters parameters = Parameters.one((String)"tool", (Object)(metadata.getTool() != null ? metadata.getTool() : "unknown"));
        YamlContractConverter converter = new YamlContractConverter();
        Object contracts = converter.convertTo(Collections.singleton(this.contract));
        Map<String, byte[]> store = converter.store((List<YamlContract>)contracts);
        parameters.put((Object)"contract", (Object)new String(store.entrySet().iterator().next().getValue()));
        requestPatternBuilder.andMatching("spring-cloud-contract", parameters);
    }

    private RequestPatternBuilder appendMethodAndUrl() {
        if (this.request.getMethod() == null) {
            return null;
        }
        RequestMethod requestMethod = RequestMethod.fromString((String)Optional.ofNullable(this.request.getMethod().getClientValue()).map(c -> c.toString()).orElse(null));
        UrlPattern urlPattern = this.urlPattern();
        return RequestPatternBuilder.newRequestPattern((RequestMethod)requestMethod, (UrlPattern)urlPattern);
    }

    private void doAppendBody(RequestPatternBuilder requestPattern) {
        if (this.request.getBody() == null) {
            return;
        }
        boolean bodyHasMatchingStrategy = this.request.getBody().getClientValue() instanceof MatchingStrategy;
        MatchingStrategy matchingStrategy = this.getMatchingStrategyFromBody(this.request.getBody());
        if (this.contentType == ContentType.JSON) {
            Object clientSideBody = MapConverter.transformToClientValues(this.request.getBody());
            Object originalBody = Optional.ofNullable(matchingStrategy).map(DslProperty::getClientValue).orElse(null);
            if (bodyHasMatchingStrategy) {
                requestPattern.withRequestBody(this.convertToValuePattern(matchingStrategy));
            } else if (clientSideBody instanceof Pattern || clientSideBody instanceof RegexProperty) {
                requestPattern.withRequestBody(this.convertToValuePattern(this.appendBodyRegexpMatchPattern(this.request.getBody(), this.contentType)));
            } else {
                Object body = JsonToJsonPathsConverter.removeMatchingJsonPaths(originalBody, this.request.getBodyMatchers());
                JsonPaths values = JsonToJsonPathsConverter.transformToJsonPathWithStubsSideValuesAndNoArraySizeCheck(body);
                if (values.isEmpty() && this.request.getBodyMatchers() != null && !this.request.getBodyMatchers().hasMatchers() || this.onlySizeAssertionsArePresent(values)) {
                    try {
                        requestPattern.withRequestBody((ContentPattern)WireMock.equalToJson((String)new JsonMapper().writeValueAsString(this.getMatchingStrategy(this.request.getBody().getClientValue()).getClientValue()), (boolean)false, (boolean)false));
                    }
                    catch (JacksonException e) {
                        throw new IllegalArgumentException("The MatchingStrategy could not be serialized", e);
                    }
                } else {
                    values.stream().filter(v -> !v.assertsSize()).forEach(it -> requestPattern.withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)it.jsonPath().replace("\\\\", "\\"))));
                }
            }
            Optional.ofNullable(this.request.getBodyMatchers()).map(BodyMatchers::matchers).ifPresent(bodyMatchers -> bodyMatchers.forEach(bodyMatcher -> {
                String newPath = JsonToJsonPathsConverter.convertJsonPathAndRegexToAJsonPath(bodyMatcher, originalBody);
                requestPattern.withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)newPath.replace("\\\\", "\\")));
            }));
        } else if (this.contentType == ContentType.XML) {
            Object originalBody = Optional.ofNullable(matchingStrategy).map(DslProperty::getClientValue).orElse(null);
            if (bodyHasMatchingStrategy) {
                requestPattern.withRequestBody(this.convertToValuePattern(matchingStrategy));
            } else {
                Object body = XmlToXPathsConverter.removeMatchingXPaths(originalBody, this.request.getBodyMatchers());
                List<BodyMatcher> byEqualityMatchersFromXml = XmlToXPathsConverter.mapToMatchers(body);
                byEqualityMatchersFromXml.forEach(bodyMatcher -> WireMockRequestStubStrategy.addWireMockStubMatchingSection(bodyMatcher, requestPattern, originalBody));
            }
            Optional.ofNullable(this.request.getBodyMatchers()).map(BodyMatchers::matchers).ifPresent(bodyMatchers -> bodyMatchers.forEach(bodyMatcher -> WireMockRequestStubStrategy.addWireMockStubMatchingSection(bodyMatcher, requestPattern, originalBody)));
        } else if (this.containsPattern(this.request.getBody())) {
            requestPattern.withRequestBody(this.convertToValuePattern(this.appendBodyRegexpMatchPattern(this.request.getBody())));
        } else {
            this.requestBodyGuessedFromMatchingStrategy(requestPattern);
        }
    }

    private Object generateConcreteValue(Object originalBody) {
        if (originalBody instanceof Pattern || originalBody instanceof RegexProperty) {
            return new RegexProperty(originalBody).generate();
        }
        return originalBody;
    }

    private RequestPatternBuilder requestBodyGuessedFromMatchingStrategy(RequestPatternBuilder requestPattern) {
        return requestPattern.withRequestBody(this.convertToValuePattern(this.getMatchingStrategy(this.request.getBody().getClientValue())));
    }

    private static void addWireMockStubMatchingSection(BodyMatcher matcher, RequestPatternBuilder requestPattern, Object body) {
        HashSet<MatchingType> matchingTypesUnsupportedForRequest = new HashSet<MatchingType>(Arrays.asList(MatchingType.NULL, MatchingType.COMMAND, MatchingType.TYPE));
        if (!(matcher instanceof PathBodyMatcher)) {
            throw new IllegalArgumentException("Only jsonPath and XPath matchers can be processed.");
        }
        String retrievedValue = Optional.ofNullable(matcher.value()).map(Object::toString).orElseGet(() -> {
            if (matchingTypesUnsupportedForRequest.contains(matcher.matchingType())) {
                throw new IllegalArgumentException("Null, Command and Type matchers are not supported in requests.");
            }
            if (MatchingType.EQUALITY == matcher.matchingType()) {
                return XmlToXPathsConverter.retrieveValue(matcher, body);
            }
            return "";
        });
        PathBodyMatcher pathMatcher = (PathBodyMatcher)matcher;
        requestPattern.withRequestBody((ContentPattern)WireMock.matchingXPath((String)pathMatcher.path(), (StringValuePattern)XPathBodyMatcherToWireMockValuePatternConverter.mapToPattern(pathMatcher.matchingType(), String.valueOf(retrievedValue))));
    }

    private boolean onlySizeAssertionsArePresent(JsonPaths values) {
        return !CollectionUtils.isEmpty((Collection)values) && (this.request.getBodyMatchers() == null || !this.request.getBodyMatchers().hasMatchers()) && this.every(values.iterator(), MethodBufferingJsonVerifiable::assertsSize);
    }

    private <T> boolean every(Iterator<T> self, Function<T, Boolean> function) {
        while (self.hasNext()) {
            if (function.apply(self.next()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private void appendMultipart(RequestPatternBuilder requestPattern) {
        if (this.request.getMultipart() == null) {
            return;
        }
        if (this.request.getMultipart().getClientValue() instanceof Map) {
            List<StringValuePattern> multipartPattern = ((Map)this.request.getMultipart().getClientValue()).entrySet().stream().map(it -> it.getValue() instanceof NamedProperty ? WireMock.matching((String)RegexPatterns.multipartFile(it.getKey(), (Object)((NamedProperty)it.getValue()).getName().getClientValue(), (Object)((NamedProperty)it.getValue()).getValue().getClientValue(), Optional.ofNullable(((NamedProperty)it.getValue()).getContentType()).map(DslProperty::getClientValue).orElse(null))) : WireMock.matching((String)RegexPatterns.multipartParam(it.getKey(), (Object)MapConverter.getStubSideValuesForNonBody(it.getValue())))).collect(Collectors.toList());
            multipartPattern.forEach(arg_0 -> ((RequestPatternBuilder)requestPattern).withRequestBody(arg_0));
        }
    }

    private void appendHeaders(RequestPatternBuilder requestPattern) {
        if (this.request.getHeaders() != null) {
            this.request.getHeaders().getEntries().forEach(header -> requestPattern.withHeader(header.getName(), (StringValuePattern)this.convertToValuePattern(header.getClientValue())));
        }
    }

    private void appendCookies(RequestPatternBuilder requestPattern) {
        if (this.request.getCookies() == null) {
            return;
        }
        this.request.getCookies().getEntries().forEach(cookie -> requestPattern.withCookie(cookie.getKey(), (StringValuePattern)this.convertToValuePattern(cookie.getClientValue())));
    }

    private UrlPattern urlPattern() {
        Object urlPath = this.urlPathOrUrlIfQueryPresent();
        if (urlPath != null) {
            if (urlPath instanceof Pattern || urlPath instanceof RegexProperty) {
                return WireMock.urlPathMatching((String)((String)this.getStubSideValue(new RegexProperty(urlPath).pattern())));
            }
            return WireMock.urlPathEqualTo((String)((String)this.getStubSideValue(urlPath.toString())));
        }
        if (this.request.getUrl() == null) {
            throw new IllegalStateException("URL is required!");
        }
        Object url = this.getUrlIfGstring(this.request.getUrl().getClientValue());
        if (url instanceof Pattern || url instanceof RegexProperty) {
            return WireMock.urlMatching((String)new RegexProperty(url).pattern());
        }
        return WireMock.urlEqualTo((String)url.toString());
    }

    private Object urlPathOrUrlIfQueryPresent() {
        Object urlPath = Optional.ofNullable(this.request).map(Request::getUrlPath).map(DslProperty::getClientValue).orElse(null);
        Object queryParamsFromUrl = Optional.ofNullable(this.request).map(Request::getUrl).map(Url::getQueryParameters).map(QueryParameters::getParameters).orElse(null);
        if (urlPath != null) {
            return urlPath;
        }
        if (queryParamsFromUrl != null) {
            return Optional.ofNullable(this.request).map(Request::getUrl).map(DslProperty::getClientValue).orElse(null);
        }
        return null;
    }

    private Object getUrlIfGstring(Object clientSide) {
        if (clientSide instanceof GString) {
            if (Arrays.stream(((GString)clientSide).getValues()).anyMatch(it -> {
                Object value = this.getStubSideValue(it);
                return value instanceof Pattern || value instanceof RegexProperty;
            })) {
                String string = this.getStubSideValue(clientSide).toString();
                return new RegexProperty((Object)Pattern.compile(string));
            }
            return this.getStubSideValue(clientSide).toString();
        }
        return clientSide;
    }

    private void appendQueryParameters(RequestPatternBuilder requestPattern) {
        QueryParameters queryParameters = Optional.ofNullable(this.request).map(Request::getUrlPath).map(Url::getQueryParameters).orElseGet(() -> Optional.ofNullable(this.request).map(Request::getUrl).map(Url::getQueryParameters).orElse(null));
        Optional.ofNullable(queryParameters).map(QueryParameters::getParameters).ifPresent(parameters -> parameters.forEach(parameter -> requestPattern.withQueryParam(parameter.getName(), (StringValuePattern)this.convertToValuePattern(parameter.getClientValue()))));
    }

    protected ContentPattern<?> convertToValuePattern(Object object) {
        if (object instanceof ClientDslProperty) {
            object = ((ClientDslProperty)object).getClientValue();
        }
        if (object instanceof Pattern || object instanceof RegexProperty) {
            return WireMock.matching((String)new RegexProperty(object).pattern());
        }
        if (object instanceof OptionalProperty) {
            return WireMock.matching((String)((OptionalProperty)object).optionalPattern());
        }
        if (object instanceof MatchingStrategy) {
            MatchingStrategy value = (MatchingStrategy)object;
            switch (value.getType()) {
                case NOT_MATCHING: {
                    return WireMock.notMatching((String)value.getClientValue().toString());
                }
                case ABSENT: {
                    return WireMock.absent();
                }
                case EQUAL_TO: {
                    return WireMock.equalTo((String)this.clientBody(value.getClientValue(), this.contentType).toString());
                }
                case CONTAINS: {
                    return WireMock.containing((String)this.clientBody(value.getClientValue(), this.contentType).toString());
                }
                case MATCHING: {
                    return WireMock.matching((String)this.clientBody(value.getClientValue(), this.contentType).toString());
                }
                case EQUAL_TO_JSON: {
                    return WireMock.equalToJson((String)this.clientBody(value.getClientValue(), this.contentType).toString());
                }
                case EQUAL_TO_XML: {
                    return WireMock.equalToXml((String)this.clientBody(value.getClientValue(), this.contentType).toString());
                }
                case BINARY_EQUAL_TO: {
                    return WireMock.binaryEqualTo((byte[])((byte[])this.clientBody(value.getClientValue(), this.contentType)));
                }
            }
            throw new UnsupportedOperationException("Unknown matching strategy " + value.getType());
        }
        return WireMock.equalTo((String)this.clientBody(object, this.contentType).toString());
    }

    protected Object clientBody(Object bodyValue, ContentType contentType) {
        if (ContentType.FORM == contentType) {
            if (bodyValue instanceof Map) {
                return ((Map)bodyValue).entrySet().stream().map(e -> StringEscapeUtils.unescapeEcmaScript((String)(e.getKey().toString() + "=" + e.getValue()))).collect(Collectors.joining("&"));
            }
            if (bodyValue instanceof List) {
                return ((List)bodyValue).stream().map(it -> StringEscapeUtils.unescapeEcmaScript((String)it.toString())).collect(Collectors.joining("&"));
            }
        } else {
            if (bodyValue instanceof FromFileProperty) {
                return ((FromFileProperty)bodyValue).isByte() ? ((FromFileProperty)bodyValue).asBytes() : (byte[])((FromFileProperty)bodyValue).asString();
            }
            if (ContentType.JSON == contentType) {
                return this.parseBody(bodyValue, contentType);
            }
        }
        return bodyValue;
    }

    private MatchingStrategy getMatchingStrategyFromBody(Body body) {
        if (body == null) {
            return null;
        }
        return this.getMatchingStrategy(body.getClientValue());
    }

    private MatchingStrategy getMatchingStrategy(Object bodyValue) {
        if (bodyValue instanceof GString) {
            return this.getMatchingStrategy((GString)bodyValue);
        }
        if (bodyValue instanceof MatchingStrategy) {
            return this.getMatchingStrategy((MatchingStrategy)bodyValue);
        }
        if (bodyValue instanceof FromFileProperty) {
            return this.getMatchingStrategy((FromFileProperty)bodyValue);
        }
        return this.tryToFindMachingStrategy(bodyValue);
    }

    private MatchingStrategy getMatchingStrategy(FromFileProperty bodyValue) {
        return new MatchingStrategy((Object)bodyValue, MatchingStrategy.Type.BINARY_EQUAL_TO);
    }

    private MatchingStrategy getMatchingStrategy(MatchingStrategy matchingStrategy) {
        return this.getMatchingStrategyIncludingContentType(matchingStrategy);
    }

    private MatchingStrategy getMatchingStrategy(GString gString) {
        if (gString == null) {
            return new MatchingStrategy((Object)"", MatchingStrategy.Type.EQUAL_TO);
        }
        Object extractedValue = ContentUtils.extractValue(gString, it -> it instanceof DslProperty ? ((DslProperty)it).getClientValue() : this.getStringFromGString(it));
        Object value = this.getStringFromGString(extractedValue);
        return this.getMatchingStrategy(value);
    }

    private Object getStringFromGString(Object object) {
        return object instanceof GString ? object.toString() : object;
    }

    private MatchingStrategy tryToFindMachingStrategy(Object bodyValue) {
        return new MatchingStrategy(MapConverter.transformToClientValues(bodyValue), ContentUtils.getEqualsTypeFromContentType(this.contentType));
    }

    private MatchingStrategy getMatchingStrategyIncludingContentType(MatchingStrategy matchingStrategy) {
        MatchingStrategy.Type type = matchingStrategy.getType();
        Object value = matchingStrategy.getClientValue();
        ContentType contentType = ContentUtils.recognizeContentTypeFromMatchingStrategy(type);
        if (contentType == ContentType.UNKNOWN && type == MatchingStrategy.Type.EQUAL_TO) {
            contentType = ContentUtils.recognizeContentTypeFromContent(value);
            type = ContentUtils.getEqualsTypeFromContentType(contentType);
        }
        MatchingStrategy newMatchingStrategy = value instanceof Map ? new MatchingStrategy((Object)this.parseBody((Map)value, contentType), type) : (value instanceof List ? new MatchingStrategy((Object)this.parseBody((List)value, contentType), type) : (value instanceof GString ? new MatchingStrategy((Object)this.parseBody((GString)value, contentType), type) : new MatchingStrategy((Object)this.parseBody(value, contentType), type)));
        return newMatchingStrategy;
    }

    private MatchingStrategy appendBodyRegexpMatchPattern(Object value, ContentType contentType) {
        Object clientValue = MapConverter.transformToClientValues(value);
        switch (contentType) {
            case JSON: {
                return new MatchingStrategy((Object)RegexpBuilders.buildJSONRegexpMatch(clientValue), MatchingStrategy.Type.MATCHING);
            }
            case UNKNOWN: {
                return new MatchingStrategy((Object)RegexpBuilders.buildGStringRegexpForStubSide(clientValue), MatchingStrategy.Type.MATCHING);
            }
        }
        throw new IllegalStateException(contentType.name() + " pattern matching is not implemented yet");
    }

    private MatchingStrategy appendBodyRegexpMatchPattern(Object value) {
        return this.appendBodyRegexpMatchPattern(value, ContentType.UNKNOWN);
    }

    private boolean containsPattern(Object o) {
        if (o instanceof GString) {
            return this.containsPattern(((GString)o).getValues());
        }
        if (o instanceof Map) {
            return this.containsPattern(((Map)o).entrySet());
        }
        if (o instanceof Collection) {
            List result = ((Collection)o).stream().map(this::containsPattern).collect(Collectors.toList());
            return result.stream().reduce(false, (a, b) -> a != false || b != false);
        }
        if (o instanceof Object[]) {
            return this.containsPattern(Arrays.asList((Object[])o));
        }
        if (o instanceof Map.Entry) {
            return this.containsPattern(((Map.Entry)o).getValue());
        }
        if (o instanceof RegexProperty) {
            return true;
        }
        if (o instanceof DslProperty) {
            return this.containsPattern(((DslProperty)o).getClientValue());
        }
        return o instanceof Pattern;
    }
}

