/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.amqp;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.contract.verifier.messaging.amqp.ContractVerifierAmqpAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={ContractVerifierAmqpAutoConfiguration.class})
@ConditionalOnProperty(value={"stubrunner.amqp.mockConnection"}, havingValue="true", matchIfMissing=true)
public class RabbitMockConnectionFactoryAutoConfiguration {
    @Bean
    public ConnectionFactory connectionFactory() {
        final Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        AMQP.Queue.DeclareOk mockDeclareOk = (AMQP.Queue.DeclareOk)Mockito.mock(AMQP.Queue.DeclareOk.class);
        com.rabbitmq.client.ConnectionFactory mockConnectionFactory = (com.rabbitmq.client.ConnectionFactory)Mockito.mock(com.rabbitmq.client.ConnectionFactory.class, (Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                if ("newConnection".equals(invocationOnMock.getMethod().getName())) {
                    return mockConnection;
                }
                return Mockito.RETURNS_DEFAULTS.answer(invocationOnMock);
            }
        });
        try {
            Channel mockChannel = (Channel)Mockito.mock(Channel.class, invocationOnMock -> {
                if ("queueDeclare".equals(invocationOnMock.getMethod().getName())) {
                    return mockDeclareOk;
                }
                return Mockito.RETURNS_DEFAULTS.answer(invocationOnMock);
            });
            Mockito.when((Object)mockConnection.isOpen()).thenReturn((Object)true);
            Mockito.when((Object)mockConnection.createChannel()).thenReturn((Object)mockChannel);
            Mockito.when((Object)mockConnection.createChannel(Mockito.anyInt())).thenReturn((Object)mockChannel);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new CachingConnectionFactory(mockConnectionFactory){};
    }
}

