/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.MethodPostProcessor;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.template.HandlebarsTemplateProcessor;
import org.springframework.cloud.contract.verifier.template.TemplateProcessor;

class TemplateUpdatingMethodPostProcessor
implements MethodPostProcessor {
    private final BlockBuilder blockBuilder;
    private final TemplateProcessor templateProcessor;

    TemplateUpdatingMethodPostProcessor(BlockBuilder blockBuilder) {
        this.blockBuilder = blockBuilder;
        this.templateProcessor = new HandlebarsTemplateProcessor();
    }

    @Override
    public MethodVisitor<MethodPostProcessor> apply(SingleContractMetadata metadata) {
        Request request = metadata.getContract().getRequest();
        String newBody = this.templateProcessor.transform(request, this.blockBuilder.toString());
        this.blockBuilder.updateContents(newBody);
        return this;
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        return this.templateProcessor.containsTemplateEntry(this.blockBuilder.toString());
    }
}

