/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.spec.internal.MatchingStrategy;
import org.springframework.cloud.contract.spec.internal.QueryParameter;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.spec.internal.Url;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.MockMvcAcceptor;
import org.springframework.cloud.contract.verifier.builder.QueryParamsResolver;
import org.springframework.cloud.contract.verifier.builder.When;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.MapConverter;

class MockMvcQueryParamsWhen
implements When,
MockMvcAcceptor,
QueryParamsResolver {
    private static final String QUERY_PARAM_METHOD = "queryParam";
    private final BlockBuilder blockBuilder;
    private final BodyParser bodyParser;

    MockMvcQueryParamsWhen(BlockBuilder blockBuilder, BodyParser bodyParser) {
        this.blockBuilder = blockBuilder;
        this.bodyParser = bodyParser;
    }

    @Override
    public MethodVisitor<When> apply(SingleContractMetadata metadata) {
        Request request = metadata.getContract().getRequest();
        Url url = this.getUrl(request);
        this.addQueryParameters(url);
        return this;
    }

    private Url getUrl(Request request) {
        if (request.getUrl() != null) {
            return request.getUrl();
        }
        if (request.getUrlPath() != null) {
            return request.getUrlPath();
        }
        throw new IllegalStateException("URL is not set!");
    }

    private void addQueryParameters(Url buildUrl) {
        List queryParameters = buildUrl.getQueryParameters().getParameters().stream().filter(this::allowedQueryParameter).collect(Collectors.toList());
        Iterator iterator = queryParameters.iterator();
        while (iterator.hasNext()) {
            QueryParameter parameter = (QueryParameter)iterator.next();
            String text = this.addQueryParameter(parameter);
            if (iterator.hasNext()) {
                this.blockBuilder.addLine(text);
                continue;
            }
            this.blockBuilder.addIndented(text);
        }
    }

    private boolean allowedQueryParameter(Object o) {
        if (o instanceof QueryParameter) {
            return this.allowedQueryParameter(((QueryParameter)o).getServerValue());
        }
        if (o instanceof MatchingStrategy) {
            return !MatchingStrategy.Type.ABSENT.equals((Object)((MatchingStrategy)o).getType());
        }
        return true;
    }

    private String addQueryParameter(QueryParameter queryParam) {
        return ".queryParam(" + this.bodyParser.quotedLongText(queryParam.getName()) + "," + this.bodyParser.quotedLongText(this.resolveParamValue(MapConverter.getTestSideValuesForNonBody(queryParam))) + ")";
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        Request request = metadata.getContract().getRequest();
        Url url = this.getUrl(request);
        return url.getQueryParameters() != null;
    }
}

