/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class TemporaryFileStorage {
    private static final Log log = LogFactory.getLog(TemporaryFileStorage.class);
    private static final int TEMP_DIR_ATTEMPTS = 10000;
    private static final BlockingQueue<File> TEMP_FILES_LOG = new LinkedBlockingQueue<File>(20000);

    private TemporaryFileStorage() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    static void add(File file) {
        TEMP_FILES_LOG.offer(file);
    }

    static Queue<File> files() {
        return TEMP_FILES_LOG;
    }

    static void cleanup(boolean deleteStubsAfterTest) {
        if (!deleteStubsAfterTest) {
            log.info((Object)"Will not clear temporary files due to switch");
            return;
        }
        for (File file : TemporaryFileStorage.files()) {
            block6: {
                try {
                    if (file.isDirectory()) {
                        Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("Removing file [" + String.valueOf(file) + "]"));
                                }
                                Files.delete(file);
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("Removing dir [" + String.valueOf(dir) + "]"));
                                }
                                Files.delete(dir);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    } else {
                        Files.delete(file.toPath());
                    }
                }
                catch (IOException | NoClassDefFoundError e) {
                    if (!log.isTraceEnabled()) break block6;
                    log.trace((Object)"Failed to remove temporary file", e);
                }
            }
            TemporaryFileStorage.files().clear();
        }
    }

    static File createTempDir(String tempDirPrefix) {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = tempDirPrefix + "-" + System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + "9999)");
    }
}

