/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilderProvider;
import org.springframework.cloud.contract.stubrunner.StubRunnerFactory;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierSender;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpStubMessages;

public class BatchStubRunnerFactory {
    private final StubRunnerOptions stubRunnerOptions;
    private final StubDownloader stubDownloader;
    private final MessageVerifierSender<?> contractVerifierMessaging;

    public BatchStubRunnerFactory(StubRunnerOptions stubRunnerOptions) {
        this(stubRunnerOptions, (MessageVerifierSender<?>)new NoOpStubMessages());
    }

    public BatchStubRunnerFactory(StubRunnerOptions stubRunnerOptions, MessageVerifierSender<?> verifier) {
        this(stubRunnerOptions, BatchStubRunnerFactory.aetherStubDownloader(stubRunnerOptions), verifier);
    }

    public BatchStubRunnerFactory(StubRunnerOptions stubRunnerOptions, StubDownloader stubDownloader) {
        this(stubRunnerOptions, stubDownloader, (MessageVerifierSender<?>)new NoOpStubMessages());
    }

    public BatchStubRunnerFactory(StubRunnerOptions stubRunnerOptions, StubDownloader stubDownloader, MessageVerifierSender<?> contractVerifierMessaging) {
        this.stubRunnerOptions = stubRunnerOptions;
        this.stubDownloader = stubDownloader;
        this.contractVerifierMessaging = contractVerifierMessaging;
    }

    private static StubDownloader aetherStubDownloader(StubRunnerOptions stubRunnerOptions) {
        StubDownloaderBuilderProvider provider = new StubDownloaderBuilderProvider();
        return provider.get(stubRunnerOptions, new StubDownloaderBuilder[0]);
    }

    public BatchStubRunner buildBatchStubRunner() {
        StubRunnerFactory stubRunnerFactory = new StubRunnerFactory(this.stubRunnerOptions, this.stubDownloader, this.contractVerifierMessaging);
        return new BatchStubRunner(stubRunnerFactory.createStubsFromServiceConfiguration());
    }
}

