/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring.cloud;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.contract.stubrunner.StubFinder;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubMapperProperties;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubRunnerDiscoveryClient;
import org.springframework.core.env.Environment;

class StubRunnerDiscoveryClientWrapper
implements BeanPostProcessor {
    private final BeanFactory beanFactory;
    StubFinder stubFinder;
    StubMapperProperties stubMapperProperties;
    String springAppName;
    Boolean stubbedDiscoveryEnabled;
    Boolean cloudDelegateEnabled;

    StubRunnerDiscoveryClientWrapper(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DiscoveryClient && !(bean instanceof StubRunnerDiscoveryClient)) {
            if (!this.isStubbedDiscoveryEnabled()) {
                return bean;
            }
            if (this.isCloudDelegateEnabled()) {
                return new StubRunnerDiscoveryClient((DiscoveryClient)bean, this.stubFinder(), this.stubMapperProperties());
            }
            return new StubRunnerDiscoveryClient(this.stubFinder(), this.stubMapperProperties());
        }
        return bean;
    }

    StubFinder stubFinder() {
        if (this.stubFinder == null) {
            this.stubFinder = (StubFinder)this.beanFactory.getBean(StubFinder.class);
        }
        return this.stubFinder;
    }

    StubMapperProperties stubMapperProperties() {
        if (this.stubMapperProperties == null) {
            this.stubMapperProperties = (StubMapperProperties)this.beanFactory.getBean(StubMapperProperties.class);
        }
        return this.stubMapperProperties;
    }

    boolean isStubbedDiscoveryEnabled() {
        if (this.stubbedDiscoveryEnabled == null) {
            this.stubbedDiscoveryEnabled = Boolean.valueOf(((Environment)this.beanFactory.getBean(Environment.class)).getProperty("stubrunner.cloud.stubbed.discovery.enabled", "true"));
        }
        return this.stubbedDiscoveryEnabled;
    }

    boolean isCloudDelegateEnabled() {
        if (this.cloudDelegateEnabled == null) {
            this.cloudDelegateEnabled = Boolean.valueOf(((Environment)this.beanFactory.getBean(Environment.class)).getProperty("stubrunner.cloud.delegate.enabled", "false"));
        }
        return this.cloudDelegateEnabled;
    }
}

