/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.util.StringUtils;

public class ContractDownloader {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final StubDownloader stubDownloader;
    private final StubConfiguration contractsJarStubConfiguration;
    private final String contractsPath;
    private final String projectGroupId;
    private final String projectArtifactId;
    private final String projectVersion;

    public ContractDownloader(StubDownloader stubDownloader, StubConfiguration contractsJarStubConfiguration, String contractsPath, String projectGroupId, String projectArtifactId, String projectVersion) {
        this.stubDownloader = stubDownloader;
        this.contractsJarStubConfiguration = contractsJarStubConfiguration;
        this.contractsPath = contractsPath;
        this.projectGroupId = projectGroupId;
        this.projectArtifactId = projectArtifactId;
        this.projectVersion = projectVersion;
    }

    @Deprecated
    public File unpackedDownloadedContracts(ContractVerifierConfigProperties config) {
        File contractsDirectory = this.unpackAndDownloadContracts();
        this.updatePropertiesWithInclusion(contractsDirectory, config);
        return contractsDirectory;
    }

    @Deprecated
    public ContractVerifierConfigProperties updatePropertiesWithInclusion(File contractsDirectory, ContractVerifierConfigProperties config) {
        InclusionProperties newInclusionProperties = this.createNewInclusionProperties(contractsDirectory);
        config.setIncludedContracts(newInclusionProperties.getIncludedContracts());
        config.setIncludedRootFolderAntPattern(newInclusionProperties.getIncludedRootFolderAntPattern());
        return config;
    }

    public File unpackAndDownloadContracts() {
        Map.Entry<StubConfiguration, File> unpackedContractStubs;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will download contracts for [" + this.contractsJarStubConfiguration + "]"));
        }
        if ((unpackedContractStubs = this.stubDownloader.downloadAndUnpackStubJar(this.contractsJarStubConfiguration)) == null) {
            throw new IllegalStateException("The contracts failed to be downloaded!");
        }
        return unpackedContractStubs.getValue();
    }

    public InclusionProperties createNewInclusionProperties(File contractsDirectory) {
        String includedAntPattern;
        String pattern;
        if (StringUtils.hasText((String)this.contractsPath)) {
            pattern = this.patternFromProperty(contractsDirectory);
            log.info((Object)"Will pick a pattern from the contractPath property");
            includedAntPattern = this.wrapWithAntPattern(this.contractsPath());
        } else {
            log.info((Object)"Will pick a pattern from group id and artifact id");
            if (this.hasGavInPath(contractsDirectory)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Group & artifact in path");
                }
                contractsDirectory = this.contractsSubDirIfPresent(contractsDirectory);
                pattern = this.fileToPattern(contractsDirectory);
                includedAntPattern = "**/";
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No group & artifact in path");
                }
                pattern = this.groupArtifactToPattern(contractsDirectory);
                includedAntPattern = this.wrapWithAntPattern(this.slashSeparatedGroupId() + "/" + this.projectArtifactId);
            }
        }
        log.info((Object)("Pattern to pick contracts equals [" + pattern + "]"));
        log.info((Object)("Ant Pattern to pick files equals [" + includedAntPattern + "]"));
        return new InclusionProperties(pattern, includedAntPattern);
    }

    private File contractsSubDirIfPresent(File contractsDirectory) {
        File contracts = new File(contractsDirectory, "contracts");
        if (contracts.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Contracts folder found [" + contracts + "]"));
            }
            contractsDirectory = contracts;
        }
        return contractsDirectory;
    }

    private boolean hasGavInPath(File file) {
        return this.hasVersionInPath(file) && this.hasSeparatedGroupInPath(file, File.separator) || this.hasSeparatedGroupInPath(file, ".");
    }

    private boolean hasVersionInPath(File file) {
        return file.getAbsolutePath().contains(this.projectVersion);
    }

    private boolean hasSeparatedGroupInPath(File file, String separator) {
        return file.getAbsolutePath().contains(this.groupAndArtifact(separator));
    }

    private String groupAndArtifact(String separator) {
        return this.projectGroupId + separator + this.projectArtifactId;
    }

    private String patternFromProperty(File contractsDirectory) {
        return ("^" + contractsDirectory.getAbsolutePath() + "(" + File.separator + ")?.*" + this.contractsPath().replace("/", File.separator) + ".*$").replace("\\", "\\\\");
    }

    private String contractsPath() {
        return this.surroundWithSeparator(this.contractsPath);
    }

    private String surroundWithSeparator(String string) {
        String path = string.startsWith(File.separator) ? string : File.separator + string;
        return path.endsWith(File.separator) ? path : path + File.separator;
    }

    private String wrapWithAntPattern(String path) {
        String changedPath = this.surroundWithSeparator(path).replace(File.separator, "/");
        return "**" + changedPath.replace(File.separator, "/") + "**/";
    }

    private String groupArtifactToPattern(File contractsDirectory) {
        return ("^" + contractsDirectory.getAbsolutePath() + "(" + File.separator + ")?.*" + this.slashSeparatedGroupId() + File.separator + this.projectArtifactId + File.separator + ".*$").replace("\\", "\\\\");
    }

    private String fileToPattern(File contractsDirectory) {
        return ("^" + contractsDirectory.getAbsolutePath() + ".*$").replace("\\", "\\\\");
    }

    private String slashSeparatedGroupId() {
        return this.projectGroupId.replace(".", File.separator);
    }

    public static class InclusionProperties {
        private final String includedContracts;
        private final String includedRootFolderAntPattern;

        InclusionProperties(String includedContracts, String includedRootFolderAntPattern) {
            this.includedContracts = includedContracts;
            this.includedRootFolderAntPattern = includedRootFolderAntPattern;
        }

        public String getIncludedContracts() {
            return this.includedContracts;
        }

        public String getIncludedRootFolderAntPattern() {
            return this.includedRootFolderAntPattern;
        }
    }
}

