/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.cloud.contract.spec.ContractDslExtensionsKt;
import org.springframework.cloud.contract.spec.internal.Body;
import org.springframework.cloud.contract.spec.internal.ClientDslProperty;
import org.springframework.cloud.contract.spec.internal.Common;
import org.springframework.cloud.contract.spec.internal.CommonDsl;
import org.springframework.cloud.contract.spec.internal.ContractDslMarker;
import org.springframework.cloud.contract.spec.internal.Cookies;
import org.springframework.cloud.contract.spec.internal.CookiesDsl;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.FromRequestDsl;
import org.springframework.cloud.contract.spec.internal.Headers;
import org.springframework.cloud.contract.spec.internal.HeadersDsl;
import org.springframework.cloud.contract.spec.internal.NotToEscapePattern;
import org.springframework.cloud.contract.spec.internal.RegexProperty;
import org.springframework.cloud.contract.spec.internal.Response;
import org.springframework.cloud.contract.spec.internal.ResponseBodyMatchers;
import org.springframework.cloud.contract.spec.internal.ResponseBodyMatchersDsl;
import org.springframework.cloud.contract.spec.internal.ServerDslProperty;
import org.springframework.cloud.contract.spec.util.RegexpUtils;

@ContractDslMarker
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\bw\n\u0002\u0018\u0002\n\u0002\b*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001:\u0004\u00ed\u0001\u00ee\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010.\u001a\u00020/J\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020/J\u001f\u0010\u0010\u001a\u0002012\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020102\u00a2\u0006\u0002\b4J\u001f\u0010\u0016\u001a\u0002012\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020102\u00a2\u0006\u0002\b4J\u001a\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\b06J7\u0010\u001c\u001a\u00020\u001d2*\u0010\u001c\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\b0908\"\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\b09\u00a2\u0006\u0002\u0010:J\u001a\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\b09J\u0014\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0;J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\bJ\u001f\u0010(\u001a\u0002012\u0017\u0010<\u001a\u0013\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020102\u00a2\u0006\u0002\b4J3\u0010\u00df\u0001\u001a$\u0012\r\u0012\u000b \u00b6\u0001*\u0004\u0018\u00010\b0\b \u00b6\u0001*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a8\u0006\u00010\u0007\u00a8\u0006\u00012\b\u0010\u00df\u0001\u001a\u00030\u00e0\u0001J3\u0010\u00e1\u0001\u001a$\u0012\r\u0012\u000b \u00b6\u0001*\u0004\u0018\u00010\b0\b \u00b6\u0001*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a8\u0006\u00010\u0007\u00a8\u0006\u00012\b\u0010\u00df\u0001\u001a\u00030\u00e0\u0001J8\u0010\u00df\u0001\u001a$\u0012\r\u0012\u000b \u00b6\u0001*\u0004\u0018\u00010\b0\b \u00b6\u0001*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a8\u0006\u00010\u0007\u00a8\u0006\u00012\r\u0010\u00df\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J8\u0010\u00e1\u0001\u001a$\u0012\r\u0012\u000b \u00b6\u0001*\u0004\u0018\u00010\b0\b \u00b6\u0001*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a8\u0006\u00010\u0007\u00a8\u0006\u00012\r\u0010\u00df\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J3\u0010\u00df\u0001\u001a$\u0012\r\u0012\u000b \u00b6\u0001*\u0004\u0018\u00010\b0\b \u00b6\u0001*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a8\u0006\u00010\u0007\u00a8\u0006\u00012\b\u0010\u00df\u0001\u001a\u00030\u00e2\u0001J3\u0010\u00e1\u0001\u001a$\u0012\r\u0012\u000b \u00b6\u0001*\u0004\u0018\u00010\b0\b \u00b6\u0001*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a8\u0006\u00010\u0007\u00a8\u0006\u00012\b\u0010\u00df\u0001\u001a\u00030\u00e2\u0001J3\u0010\u00df\u0001\u001a$\u0012\r\u0012\u000b \u00b6\u0001*\u0004\u0018\u00010\b0\b \u00b6\u0001*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a8\u0006\u00010\u0007\u00a8\u0006\u00012\b\u0010\u00df\u0001\u001a\u00030\u00e3\u0001J3\u0010\u00e1\u0001\u001a$\u0012\r\u0012\u000b \u00b6\u0001*\u0004\u0018\u00010\b0\b \u00b6\u0001*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a8\u0006\u00010\u0007\u00a8\u0006\u00012\b\u0010\u00df\u0001\u001a\u00030\u00e3\u0001J4\u0010\u00df\u0001\u001a$\u0012\r\u0012\u000b \u00b6\u0001*\u0004\u0018\u00010\b0\b \u00b6\u0001*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a8\u0006\u00010\u0007\u00a8\u0006\u00012\t\u0010\u00df\u0001\u001a\u0004\u0018\u00010\bJ4\u0010\u00e1\u0001\u001a$\u0012\r\u0012\u000b \u00b6\u0001*\u0004\u0018\u00010\b0\b \u00b6\u0001*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a8\u0006\u00010\u0007\u00a8\u0006\u00012\t\u0010\u00df\u0001\u001a\u0004\u0018\u00010\bJ=\u0010\u00df\u0001\u001a$\u0012\r\u0012\u000b \u00b6\u0001*\u0004\u0018\u00010\b0\b \u00b6\u0001*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a8\u0006\u00010\u0007\u00a8\u0006\u00012\b\u0010\u00e4\u0001\u001a\u00030\u00e0\u00012\b\u0010\u00e5\u0001\u001a\u00030\u00b5\u0001J=\u0010\u00e1\u0001\u001a$\u0012\r\u0012\u000b \u00b6\u0001*\u0004\u0018\u00010\b0\b \u00b6\u0001*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a8\u0006\u00010\u0007\u00a8\u0006\u00012\b\u0010\u00e4\u0001\u001a\u00030\u00e0\u00012\b\u0010\u00e5\u0001\u001a\u00030\u00b5\u0001J=\u0010\u00df\u0001\u001a$\u0012\r\u0012\u000b \u00b6\u0001*\u0004\u0018\u00010\b0\b \u00b6\u0001*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a8\u0006\u00010\u0007\u00a8\u0006\u00012\b\u0010\u00e5\u0001\u001a\u00030\u00b5\u00012\b\u0010\u00e4\u0001\u001a\u00030\u00e0\u0001J=\u0010\u00e1\u0001\u001a$\u0012\r\u0012\u000b \u00b6\u0001*\u0004\u0018\u00010\b0\b \u00b6\u0001*\u000b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a8\u0006\u00010\u0007\u00a8\u0006\u00012\b\u0010\u00e5\u0001\u001a\u00030\u00b5\u00012\b\u0010\u00e4\u0001\u001a\u00030\u00e0\u0001J\b\u0010\u00e6\u0001\u001a\u00030\u00e7\u0001J1\u0010\u00e8\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00012\u0017\u0010\u00e9\u0001\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010708\"\u0004\u0018\u000107\u00a2\u0006\u0003\u0010\u00ea\u0001J\u000f\u0010\u00eb\u0001\u001a\u00020\u0005H\u0000\u00a2\u0006\u0003\b\u00ec\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0017\u0010>\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b?\u0010\nR\u0017\u0010@\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bA\u0010\nR\u0017\u0010B\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bC\u0010\nR\u0017\u0010D\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bE\u0010\nR\u0017\u0010F\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bG\u0010\nR\u0017\u0010H\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bI\u0010\nR\u0017\u0010J\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bK\u0010\nR\u0017\u0010L\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bM\u0010\nR\u0017\u0010N\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bO\u0010\nR\u0017\u0010P\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bQ\u0010\nR\u0017\u0010R\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bS\u0010\nR\u0017\u0010T\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bU\u0010\nR\u0017\u0010V\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bW\u0010\nR\u0017\u0010X\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bY\u0010\nR\u0017\u0010Z\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b[\u0010\nR\u0017\u0010\\\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b]\u0010\nR\u0017\u0010^\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b_\u0010\nR\u0017\u0010`\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\ba\u0010\nR\u0017\u0010b\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bc\u0010\nR\u0017\u0010d\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\be\u0010\nR\u0017\u0010f\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bg\u0010\nR\u0017\u0010h\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bi\u0010\nR\u0017\u0010j\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bk\u0010\nR\u0017\u0010l\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bm\u0010\nR\u0017\u0010n\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bo\u0010\nR\u0017\u0010p\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bq\u0010\nR\u0017\u0010r\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bs\u0010\nR\u0017\u0010t\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bu\u0010\nR\u0017\u0010v\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\bw\u0010\nR\u0017\u0010x\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\by\u0010\nR\u0017\u0010z\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b{\u0010\nR\u0017\u0010|\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b}\u0010\nR\u0017\u0010~\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u007f\u0010\nR\u0019\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u0081\u0001\u0010\nR\u0019\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u0083\u0001\u0010\nR\u0019\u0010\u0084\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u0085\u0001\u0010\nR\u0019\u0010\u0086\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u0087\u0001\u0010\nR\u0019\u0010\u0088\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u0089\u0001\u0010\nR\u0019\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u008b\u0001\u0010\nR\u0019\u0010\u008c\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u008d\u0001\u0010\nR\u0019\u0010\u008e\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u008f\u0001\u0010\nR\u0019\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u0091\u0001\u0010\nR\u0019\u0010\u0092\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u0093\u0001\u0010\nR\u0019\u0010\u0094\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u0095\u0001\u0010\nR\u0019\u0010\u0096\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u0097\u0001\u0010\nR\u0019\u0010\u0098\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u0099\u0001\u0010\nR\u0019\u0010\u009a\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u009b\u0001\u0010\nR\u0019\u0010\u009c\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u009d\u0001\u0010\nR\u0019\u0010\u009e\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u009f\u0001\u0010\nR\u0019\u0010\u00a0\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u00a1\u0001\u0010\nR\u0019\u0010\u00a2\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u00a3\u0001\u0010\nR\u0019\u0010\u00a4\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u00a5\u0001\u0010\nR\u0019\u0010\u00a6\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u00a7\u0001\u0010\nR\u0019\u0010\u00a8\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u00a9\u0001\u0010\nR\u0019\u0010\u00aa\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u00ab\u0001\u0010\nR\u0019\u0010\u00ac\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u00ad\u0001\u0010\nR\u0019\u0010\u00ae\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u00af\u0001\u0010\nR\u0019\u0010\u00b0\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u00b1\u0001\u0010\nR\u0019\u0010\u00b2\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F\u00a2\u0006\u0007\u001a\u0005\b\u00b3\u0001\u0010\nR\u001f\u0010\u00b4\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00b7\u0001\u0010\u00b8\u0001R\u001f\u0010\u00b9\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00ba\u0001\u0010\u00b8\u0001R\u001f\u0010\u00bb\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00bc\u0001\u0010\u00b8\u0001R\u001f\u0010\u00bd\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00be\u0001\u0010\u00b8\u0001R\u001f\u0010\u00bf\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00c0\u0001\u0010\u00b8\u0001R\u001f\u0010\u00c1\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00c2\u0001\u0010\u00b8\u0001R\u001f\u0010\u00c3\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00c4\u0001\u0010\u00b8\u0001R\u001f\u0010\u00c5\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00c6\u0001\u0010\u00b8\u0001R\u001f\u0010\u00c7\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00c8\u0001\u0010\u00b8\u0001R\u001f\u0010\u00c9\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00ca\u0001\u0010\u00b8\u0001R\u001f\u0010\u00cb\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00cc\u0001\u0010\u00b8\u0001R\u001f\u0010\u00cd\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00ce\u0001\u0010\u00b8\u0001R\u001f\u0010\u00cf\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00d0\u0001\u0010\u00b8\u0001R\u001f\u0010\u00d1\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00d2\u0001\u0010\u00b8\u0001R\u001f\u0010\u00d3\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00d4\u0001\u0010\u00b8\u0001R\u001f\u0010\u00d5\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00d6\u0001\u0010\u00b8\u0001R\u001f\u0010\u00d7\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00d8\u0001\u0010\u00b8\u0001R\u001f\u0010\u00d9\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00da\u0001\u0010\u00b8\u0001R\u001f\u0010\u00db\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00dc\u0001\u0010\u00b8\u0001R\u001f\u0010\u00dd\u0001\u001a\r \u00b6\u0001*\u0005\u0018\u00010\u00b5\u00010\u00b5\u00018F\u00a2\u0006\b\u001a\u0006\b\u00de\u0001\u0010\u00b8\u0001\u00a8\u0006\u00ef\u0001"}, d2={"Lorg/springframework/cloud/contract/spec/internal/ResponseDsl;", "Lorg/springframework/cloud/contract/spec/internal/CommonDsl;", "<init>", "()V", "delegate", "Lorg/springframework/cloud/contract/spec/internal/Response;", "status", "Lorg/springframework/cloud/contract/spec/internal/DslProperty;", "", "getStatus", "()Lorg/springframework/cloud/contract/spec/internal/DslProperty;", "setStatus", "(Lorg/springframework/cloud/contract/spec/internal/DslProperty;)V", "delay", "getDelay", "setDelay", "headers", "Lorg/springframework/cloud/contract/spec/internal/Headers;", "getHeaders", "()Lorg/springframework/cloud/contract/spec/internal/Headers;", "setHeaders", "(Lorg/springframework/cloud/contract/spec/internal/Headers;)V", "cookies", "Lorg/springframework/cloud/contract/spec/internal/Cookies;", "getCookies", "()Lorg/springframework/cloud/contract/spec/internal/Cookies;", "setCookies", "(Lorg/springframework/cloud/contract/spec/internal/Cookies;)V", "body", "Lorg/springframework/cloud/contract/spec/internal/Body;", "getBody", "()Lorg/springframework/cloud/contract/spec/internal/Body;", "setBody", "(Lorg/springframework/cloud/contract/spec/internal/Body;)V", "async", "", "getAsync", "()Z", "setAsync", "(Z)V", "bodyMatchers", "Lorg/springframework/cloud/contract/spec/internal/ResponseBodyMatchers;", "getBodyMatchers", "()Lorg/springframework/cloud/contract/spec/internal/ResponseBodyMatchers;", "setBodyMatchers", "(Lorg/springframework/cloud/contract/spec/internal/ResponseBodyMatchers;)V", "code", "", "fixedMilliseconds", "", "Lkotlin/Function1;", "Lorg/springframework/cloud/contract/spec/internal/HeadersDsl;", "Lkotlin/ExtensionFunctionType;", "Lorg/springframework/cloud/contract/spec/internal/CookiesDsl;", "", "", "", "Lkotlin/Pair;", "([Lkotlin/Pair;)Lorg/springframework/cloud/contract/spec/internal/Body;", "", "configurer", "Lorg/springframework/cloud/contract/spec/internal/ResponseBodyMatchersDsl;", "CONTINUE", "getCONTINUE", "SWITCHING_PROTOCOLS", "getSWITCHING_PROTOCOLS", "PROCESSING", "getPROCESSING", "CHECKPOINT", "getCHECKPOINT", "OK", "getOK", "CREATED", "getCREATED", "ACCEPTED", "getACCEPTED", "NON_AUTHORITATIVE_INFORMATION", "getNON_AUTHORITATIVE_INFORMATION", "NO_CONTENT", "getNO_CONTENT", "RESET_CONTENT", "getRESET_CONTENT", "PARTIAL_CONTENT", "getPARTIAL_CONTENT", "MULTI_STATUS", "getMULTI_STATUS", "ALREADY_REPORTED", "getALREADY_REPORTED", "IM_USED", "getIM_USED", "MULTIPLE_CHOICES", "getMULTIPLE_CHOICES", "MOVED_PERMANENTLY", "getMOVED_PERMANENTLY", "FOUND", "getFOUND", "SEE_OTHER", "getSEE_OTHER", "NOT_MODIFIED", "getNOT_MODIFIED", "TEMPORARY_REDIRECT", "getTEMPORARY_REDIRECT", "PERMANENT_REDIRECT", "getPERMANENT_REDIRECT", "BAD_REQUEST", "getBAD_REQUEST", "UNAUTHORIZED", "getUNAUTHORIZED", "PAYMENT_REQUIRED", "getPAYMENT_REQUIRED", "FORBIDDEN", "getFORBIDDEN", "NOT_FOUND", "getNOT_FOUND", "METHOD_NOT_ALLOWED", "getMETHOD_NOT_ALLOWED", "NOT_ACCEPTABLE", "getNOT_ACCEPTABLE", "PROXY_AUTHENTICATION_REQUIRED", "getPROXY_AUTHENTICATION_REQUIRED", "REQUEST_TIMEOUT", "getREQUEST_TIMEOUT", "CONFLICT", "getCONFLICT", "GONE", "getGONE", "LENGTH_REQUIRED", "getLENGTH_REQUIRED", "PRECONDITION_FAILED", "getPRECONDITION_FAILED", "PAYLOAD_TOO_LARGE", "getPAYLOAD_TOO_LARGE", "UNSUPPORTED_MEDIA_TYPE", "getUNSUPPORTED_MEDIA_TYPE", "REQUESTED_RANGE_NOT_SATISFIABLE", "getREQUESTED_RANGE_NOT_SATISFIABLE", "EXPECTATION_FAILED", "getEXPECTATION_FAILED", "I_AM_A_TEAPOT", "getI_AM_A_TEAPOT", "UNPROCESSABLE_ENTITY", "getUNPROCESSABLE_ENTITY", "LOCKED", "getLOCKED", "FAILED_DEPENDENCY", "getFAILED_DEPENDENCY", "UPGRADE_REQUIRED", "getUPGRADE_REQUIRED", "PRECONDITION_REQUIRED", "getPRECONDITION_REQUIRED", "TOO_MANY_REQUESTS", "getTOO_MANY_REQUESTS", "REQUEST_HEADER_FIELDS_TOO_LARGE", "getREQUEST_HEADER_FIELDS_TOO_LARGE", "UNAVAILABLE_FOR_LEGAL_REASONS", "getUNAVAILABLE_FOR_LEGAL_REASONS", "INTERNAL_SERVER_ERROR", "getINTERNAL_SERVER_ERROR", "NOT_IMPLEMENTED", "getNOT_IMPLEMENTED", "BAD_GATEWAY", "getBAD_GATEWAY", "SERVICE_UNAVAILABLE", "getSERVICE_UNAVAILABLE", "GATEWAY_TIMEOUT", "getGATEWAY_TIMEOUT", "HTTP_VERSION_NOT_SUPPORTED", "getHTTP_VERSION_NOT_SUPPORTED", "VARIANT_ALSO_NEGOTIATES", "getVARIANT_ALSO_NEGOTIATES", "INSUFFICIENT_STORAGE", "getINSUFFICIENT_STORAGE", "LOOP_DETECTED", "getLOOP_DETECTED", "BANDWIDTH_LIMIT_EXCEEDED", "getBANDWIDTH_LIMIT_EXCEEDED", "NOT_EXTENDED", "getNOT_EXTENDED", "NETWORK_AUTHENTICATION_REQUIRED", "getNETWORK_AUTHENTICATION_REQUIRED", "anyAlphaUnicode", "Lorg/springframework/cloud/contract/spec/internal/ServerDslProperty;", "kotlin.jvm.PlatformType", "getAnyAlphaUnicode", "()Lorg/springframework/cloud/contract/spec/internal/ServerDslProperty;", "anyAlphaNumeric", "getAnyAlphaNumeric", "anyNumber", "getAnyNumber", "anyInteger", "getAnyInteger", "anyPositiveInt", "getAnyPositiveInt", "anyDouble", "getAnyDouble", "anyHex", "getAnyHex", "aBoolean", "getABoolean", "anyIpAddress", "getAnyIpAddress", "anyHostname", "getAnyHostname", "anyEmail", "getAnyEmail", "anyUrl", "getAnyUrl", "anyHttpsUrl", "getAnyHttpsUrl", "anyUuid", "getAnyUuid", "anyDate", "getAnyDate", "anyDateTime", "getAnyDateTime", "anyTime", "getAnyTime", "anyIso8601WithOffset", "getAnyIso8601WithOffset", "anyNonBlankString", "getAnyNonBlankString", "anyNonEmptyString", "getAnyNonEmptyString", "value", "Lorg/springframework/cloud/contract/spec/internal/ClientDslProperty;", "v", "Ljava/util/regex/Pattern;", "Lorg/springframework/cloud/contract/spec/internal/RegexProperty;", "client", "server", "fromRequest", "Lorg/springframework/cloud/contract/spec/internal/FromRequestDsl;", "anyOf", "values", "([Ljava/lang/String;)Lorg/springframework/cloud/contract/spec/internal/ServerDslProperty;", "get", "get$spring_cloud_contract_spec_kotlin", "ResponseHeadersDsl", "ResponseCookiesDsl", "spring-cloud-contract-spec-kotlin"})
@SourceDebugExtension(value={"SMAP\nResponseDsl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseDsl.kt\norg/springframework/cloud/contract/spec/internal/ResponseDsl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,421:1\n1#2:422\n*E\n"})
public final class ResponseDsl
extends CommonDsl {
    @NotNull
    private final Response delegate = new Response();
    @Nullable
    private DslProperty<Object> status;
    @Nullable
    private DslProperty<Object> delay;
    @Nullable
    private Headers headers;
    @Nullable
    private Cookies cookies;
    @Nullable
    private Body body;
    private boolean async;
    @Nullable
    private ResponseBodyMatchers bodyMatchers;

    @Nullable
    public final DslProperty<Object> getStatus() {
        return this.status;
    }

    public final void setStatus(@Nullable DslProperty<Object> dslProperty) {
        this.status = dslProperty;
    }

    @Nullable
    public final DslProperty<Object> getDelay() {
        return this.delay;
    }

    public final void setDelay(@Nullable DslProperty<Object> dslProperty) {
        this.delay = dslProperty;
    }

    @Nullable
    public final Headers getHeaders() {
        return this.headers;
    }

    public final void setHeaders(@Nullable Headers headers) {
        this.headers = headers;
    }

    @Nullable
    public final Cookies getCookies() {
        return this.cookies;
    }

    public final void setCookies(@Nullable Cookies cookies) {
        this.cookies = cookies;
    }

    @Nullable
    public final Body getBody() {
        return this.body;
    }

    public final void setBody(@Nullable Body body) {
        this.body = body;
    }

    public final boolean getAsync() {
        return this.async;
    }

    public final void setAsync(boolean bl) {
        this.async = bl;
    }

    @Nullable
    public final ResponseBodyMatchers getBodyMatchers() {
        return this.bodyMatchers;
    }

    public final void setBodyMatchers(@Nullable ResponseBodyMatchers responseBodyMatchers) {
        this.bodyMatchers = responseBodyMatchers;
    }

    @NotNull
    public final DslProperty<Object> code(int code) {
        return ContractDslExtensionsKt.toDslProperty(code);
    }

    @NotNull
    public final DslProperty<Object> fixedMilliseconds(int delay) {
        return ContractDslExtensionsKt.toDslProperty(delay);
    }

    public final void headers(@NotNull Function1<? super HeadersDsl, Unit> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        ResponseHeadersDsl responseHeadersDsl = new ResponseHeadersDsl();
        headers.invoke((Object)responseHeadersDsl);
        this.headers = responseHeadersDsl.get$spring_cloud_contract_spec_kotlin();
    }

    public final void cookies(@NotNull Function1<? super CookiesDsl, Unit> cookies) {
        Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
        ResponseCookiesDsl responseCookiesDsl = new ResponseCookiesDsl();
        cookies.invoke((Object)responseCookiesDsl);
        this.cookies = responseCookiesDsl.get$spring_cloud_contract_spec_kotlin();
    }

    @NotNull
    public final Body body(@NotNull Map<String, ? extends Object> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return new Body(ContractDslExtensionsKt.toDslProperties(body));
    }

    @NotNull
    public final Body body(Pair<String, ? extends Object> ... body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return new Body(ContractDslExtensionsKt.toDslProperties(MapsKt.toMap(body)));
    }

    @NotNull
    public final Body body(@NotNull Pair<String, ? extends Object> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return new Body(ContractDslExtensionsKt.toDslProperties(MapsKt.mapOf(body)));
    }

    @NotNull
    public final Body body(@NotNull List<? extends Object> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return new Body(ContractDslExtensionsKt.toDslProperties(body));
    }

    @NotNull
    public final Body body(@NotNull Object body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return new Body(body);
    }

    public final void bodyMatchers(@NotNull Function1<? super ResponseBodyMatchersDsl, Unit> configurer) {
        Intrinsics.checkNotNullParameter(configurer, (String)"configurer");
        ResponseBodyMatchersDsl responseBodyMatchersDsl = new ResponseBodyMatchersDsl();
        configurer.invoke((Object)responseBodyMatchersDsl);
        this.bodyMatchers = responseBodyMatchersDsl.get$spring_cloud_contract_spec_kotlin();
    }

    @NotNull
    public final DslProperty<Object> getCONTINUE() {
        return this.code(100);
    }

    @NotNull
    public final DslProperty<Object> getSWITCHING_PROTOCOLS() {
        return this.code(101);
    }

    @NotNull
    public final DslProperty<Object> getPROCESSING() {
        return this.code(102);
    }

    @NotNull
    public final DslProperty<Object> getCHECKPOINT() {
        return this.code(103);
    }

    @NotNull
    public final DslProperty<Object> getOK() {
        return this.code(200);
    }

    @NotNull
    public final DslProperty<Object> getCREATED() {
        return this.code(201);
    }

    @NotNull
    public final DslProperty<Object> getACCEPTED() {
        return this.code(202);
    }

    @NotNull
    public final DslProperty<Object> getNON_AUTHORITATIVE_INFORMATION() {
        return this.code(203);
    }

    @NotNull
    public final DslProperty<Object> getNO_CONTENT() {
        return this.code(204);
    }

    @NotNull
    public final DslProperty<Object> getRESET_CONTENT() {
        return this.code(205);
    }

    @NotNull
    public final DslProperty<Object> getPARTIAL_CONTENT() {
        return this.code(206);
    }

    @NotNull
    public final DslProperty<Object> getMULTI_STATUS() {
        return this.code(207);
    }

    @NotNull
    public final DslProperty<Object> getALREADY_REPORTED() {
        return this.code(208);
    }

    @NotNull
    public final DslProperty<Object> getIM_USED() {
        return this.code(226);
    }

    @NotNull
    public final DslProperty<Object> getMULTIPLE_CHOICES() {
        return this.code(300);
    }

    @NotNull
    public final DslProperty<Object> getMOVED_PERMANENTLY() {
        return this.code(301);
    }

    @NotNull
    public final DslProperty<Object> getFOUND() {
        return this.code(302);
    }

    @NotNull
    public final DslProperty<Object> getSEE_OTHER() {
        return this.code(303);
    }

    @NotNull
    public final DslProperty<Object> getNOT_MODIFIED() {
        return this.code(304);
    }

    @NotNull
    public final DslProperty<Object> getTEMPORARY_REDIRECT() {
        return this.code(307);
    }

    @NotNull
    public final DslProperty<Object> getPERMANENT_REDIRECT() {
        return this.code(308);
    }

    @NotNull
    public final DslProperty<Object> getBAD_REQUEST() {
        return this.code(400);
    }

    @NotNull
    public final DslProperty<Object> getUNAUTHORIZED() {
        return this.code(401);
    }

    @NotNull
    public final DslProperty<Object> getPAYMENT_REQUIRED() {
        return this.code(402);
    }

    @NotNull
    public final DslProperty<Object> getFORBIDDEN() {
        return this.code(403);
    }

    @NotNull
    public final DslProperty<Object> getNOT_FOUND() {
        return this.code(404);
    }

    @NotNull
    public final DslProperty<Object> getMETHOD_NOT_ALLOWED() {
        return this.code(405);
    }

    @NotNull
    public final DslProperty<Object> getNOT_ACCEPTABLE() {
        return this.code(406);
    }

    @NotNull
    public final DslProperty<Object> getPROXY_AUTHENTICATION_REQUIRED() {
        return this.code(407);
    }

    @NotNull
    public final DslProperty<Object> getREQUEST_TIMEOUT() {
        return this.code(408);
    }

    @NotNull
    public final DslProperty<Object> getCONFLICT() {
        return this.code(409);
    }

    @NotNull
    public final DslProperty<Object> getGONE() {
        return this.code(410);
    }

    @NotNull
    public final DslProperty<Object> getLENGTH_REQUIRED() {
        return this.code(411);
    }

    @NotNull
    public final DslProperty<Object> getPRECONDITION_FAILED() {
        return this.code(412);
    }

    @NotNull
    public final DslProperty<Object> getPAYLOAD_TOO_LARGE() {
        return this.code(413);
    }

    @NotNull
    public final DslProperty<Object> getUNSUPPORTED_MEDIA_TYPE() {
        return this.code(415);
    }

    @NotNull
    public final DslProperty<Object> getREQUESTED_RANGE_NOT_SATISFIABLE() {
        return this.code(416);
    }

    @NotNull
    public final DslProperty<Object> getEXPECTATION_FAILED() {
        return this.code(417);
    }

    @NotNull
    public final DslProperty<Object> getI_AM_A_TEAPOT() {
        return this.code(418);
    }

    @NotNull
    public final DslProperty<Object> getUNPROCESSABLE_ENTITY() {
        return this.code(422);
    }

    @NotNull
    public final DslProperty<Object> getLOCKED() {
        return this.code(423);
    }

    @NotNull
    public final DslProperty<Object> getFAILED_DEPENDENCY() {
        return this.code(424);
    }

    @NotNull
    public final DslProperty<Object> getUPGRADE_REQUIRED() {
        return this.code(426);
    }

    @NotNull
    public final DslProperty<Object> getPRECONDITION_REQUIRED() {
        return this.code(428);
    }

    @NotNull
    public final DslProperty<Object> getTOO_MANY_REQUESTS() {
        return this.code(429);
    }

    @NotNull
    public final DslProperty<Object> getREQUEST_HEADER_FIELDS_TOO_LARGE() {
        return this.code(431);
    }

    @NotNull
    public final DslProperty<Object> getUNAVAILABLE_FOR_LEGAL_REASONS() {
        return this.code(451);
    }

    @NotNull
    public final DslProperty<Object> getINTERNAL_SERVER_ERROR() {
        return this.code(500);
    }

    @NotNull
    public final DslProperty<Object> getNOT_IMPLEMENTED() {
        return this.code(501);
    }

    @NotNull
    public final DslProperty<Object> getBAD_GATEWAY() {
        return this.code(502);
    }

    @NotNull
    public final DslProperty<Object> getSERVICE_UNAVAILABLE() {
        return this.code(503);
    }

    @NotNull
    public final DslProperty<Object> getGATEWAY_TIMEOUT() {
        return this.code(504);
    }

    @NotNull
    public final DslProperty<Object> getHTTP_VERSION_NOT_SUPPORTED() {
        return this.code(505);
    }

    @NotNull
    public final DslProperty<Object> getVARIANT_ALSO_NEGOTIATES() {
        return this.code(506);
    }

    @NotNull
    public final DslProperty<Object> getINSUFFICIENT_STORAGE() {
        return this.code(507);
    }

    @NotNull
    public final DslProperty<Object> getLOOP_DETECTED() {
        return this.code(508);
    }

    @NotNull
    public final DslProperty<Object> getBANDWIDTH_LIMIT_EXCEEDED() {
        return this.code(509);
    }

    @NotNull
    public final DslProperty<Object> getNOT_EXTENDED() {
        return this.code(510);
    }

    @NotNull
    public final DslProperty<Object> getNETWORK_AUTHENTICATION_REQUIRED() {
        return this.code(511);
    }

    public final ServerDslProperty getAnyAlphaUnicode() {
        return this.delegate.anyAlphaUnicode();
    }

    public final ServerDslProperty getAnyAlphaNumeric() {
        return this.delegate.anyAlphaNumeric();
    }

    public final ServerDslProperty getAnyNumber() {
        return this.delegate.anyNumber();
    }

    public final ServerDslProperty getAnyInteger() {
        return this.delegate.anyInteger();
    }

    public final ServerDslProperty getAnyPositiveInt() {
        return this.delegate.anyPositiveInt();
    }

    public final ServerDslProperty getAnyDouble() {
        return this.delegate.anyDouble();
    }

    public final ServerDslProperty getAnyHex() {
        return this.delegate.anyHex();
    }

    public final ServerDslProperty getABoolean() {
        return this.delegate.aBoolean();
    }

    public final ServerDslProperty getAnyIpAddress() {
        return this.delegate.anyIpAddress();
    }

    public final ServerDslProperty getAnyHostname() {
        return this.delegate.anyHostname();
    }

    public final ServerDslProperty getAnyEmail() {
        return this.delegate.anyEmail();
    }

    public final ServerDslProperty getAnyUrl() {
        return this.delegate.anyUrl();
    }

    public final ServerDslProperty getAnyHttpsUrl() {
        return this.delegate.anyHttpsUrl();
    }

    public final ServerDslProperty getAnyUuid() {
        return this.delegate.anyUuid();
    }

    public final ServerDslProperty getAnyDate() {
        return this.delegate.anyDate();
    }

    public final ServerDslProperty getAnyDateTime() {
        return this.delegate.anyDateTime();
    }

    public final ServerDslProperty getAnyTime() {
        return this.delegate.anyTime();
    }

    public final ServerDslProperty getAnyIso8601WithOffset() {
        return this.delegate.anyIso8601WithOffset();
    }

    public final ServerDslProperty getAnyNonBlankString() {
        return this.delegate.anyNonBlankString();
    }

    public final ServerDslProperty getAnyNonEmptyString() {
        return this.delegate.anyNonEmptyString();
    }

    public final DslProperty value(@NotNull ClientDslProperty value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.delegate.value((DslProperty)value);
    }

    public final DslProperty v(@NotNull ClientDslProperty value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.delegate.value((DslProperty)value);
    }

    public final DslProperty value(@NotNull DslProperty<Object> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.delegate.value(value);
    }

    public final DslProperty v(@NotNull DslProperty<Object> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.delegate.value(value);
    }

    public final DslProperty value(@NotNull Pattern value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.delegate.value(value);
    }

    public final DslProperty v(@NotNull Pattern value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.delegate.value(value);
    }

    public final DslProperty value(@NotNull RegexProperty value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.delegate.value(value);
    }

    public final DslProperty v(@NotNull RegexProperty value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.delegate.value(value);
    }

    public final DslProperty value(@Nullable Object value) {
        return this.delegate.value(value);
    }

    public final DslProperty v(@Nullable Object value) {
        return this.delegate.value(value);
    }

    public final DslProperty value(@NotNull ClientDslProperty client, @NotNull ServerDslProperty server) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        return this.delegate.value(client, server);
    }

    public final DslProperty v(@NotNull ClientDslProperty client, @NotNull ServerDslProperty server) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        return this.delegate.value(client, server);
    }

    public final DslProperty value(@NotNull ServerDslProperty server, @NotNull ClientDslProperty client) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return this.delegate.value(client, server);
    }

    public final DslProperty v(@NotNull ServerDslProperty server, @NotNull ClientDslProperty client) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return this.delegate.value(client, server);
    }

    @NotNull
    public final FromRequestDsl fromRequest() {
        return new FromRequestDsl();
    }

    public final ServerDslProperty anyOf(String ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return this.delegate.anyOf(Arrays.copyOf(values, values.length));
    }

    @NotNull
    public final Response get$spring_cloud_contract_spec_kotlin() {
        Response response;
        block5: {
            Headers it;
            Headers headers;
            response = new Response();
            Headers headers2 = this.status;
            if (headers2 != null) {
                it = headers = headers2;
                boolean bl = false;
                response.setStatus(this.status);
            }
            DslProperty<Object> dslProperty = this.delay;
            if (dslProperty != null) {
                it = headers = dslProperty;
                boolean bl = false;
                response.setDelay(this.delay);
            }
            Headers headers3 = this.headers;
            if (headers3 != null) {
                it = headers = headers3;
                boolean bl = false;
                response.setHeaders(this.headers);
            }
            Cookies cookies = this.cookies;
            if (cookies != null) {
                it = headers = cookies;
                boolean bl = false;
                response.setCookies(this.cookies);
            }
            Body body = this.body;
            if (body != null) {
                it = headers = body;
                boolean bl = false;
                response.setBody(this.body);
            }
            response.setAsync(this.async);
            ResponseBodyMatchers responseBodyMatchers = this.bodyMatchers;
            if (responseBodyMatchers == null) break block5;
            it = headers = responseBodyMatchers;
            boolean bl = false;
            response.setBodyMatchers(this.bodyMatchers);
        }
        return response;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/springframework/cloud/contract/spec/internal/ResponseDsl$ResponseCookiesDsl;", "Lorg/springframework/cloud/contract/spec/internal/CookiesDsl;", "<init>", "()V", "common", "Lorg/springframework/cloud/contract/spec/internal/Common;", "matching", "", "value", "spring-cloud-contract-spec-kotlin"})
    private static final class ResponseCookiesDsl
    extends CookiesDsl {
        @NotNull
        private final Common common = new Common();

        @Override
        @Nullable
        public Object matching(@Nullable Object value) {
            if (value != null) {
                Object it = value;
                boolean bl = false;
                if (value instanceof String) {
                    return this.common.value(this.c(value), this.p(this.regex(RegexpUtils.escapeSpecialRegexWithSingleEscape((String)((String)value)) + ".*")));
                }
                return value;
            }
            return null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/springframework/cloud/contract/spec/internal/ResponseDsl$ResponseHeadersDsl;", "Lorg/springframework/cloud/contract/spec/internal/HeadersDsl;", "<init>", "()V", "common", "Lorg/springframework/cloud/contract/spec/internal/Common;", "matching", "", "value", "spring-cloud-contract-spec-kotlin"})
    private static final class ResponseHeadersDsl
    extends HeadersDsl {
        @NotNull
        private final Common common = new Common();

        @Override
        @Nullable
        public Object matching(@Nullable Object value) {
            if (value != null) {
                Object it = value;
                boolean bl = false;
                if (value instanceof String) {
                    return this.common.value(this.c(value), this.p(new NotToEscapePattern(Pattern.compile(RegexpUtils.escapeSpecialRegexWithSingleEscape((String)((String)value)) + ".*"))));
                }
                return value;
            }
            return null;
        }
    }
}

