/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.EvaluationResult;
import kotlin.script.experimental.api.ResultValue;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationConfigurationKeys;
import kotlin.script.experimental.host.ScriptHostUtilKt;
import kotlin.script.experimental.jvm.JvmScriptCompilationConfigurationBuilder;
import kotlin.script.experimental.jvm.JvmScriptCompilationKt;
import kotlin.script.experimental.jvmhost.BasicJvmScriptingHost;
import kotlin.script.experimental.util.PropertiesCollection;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.ContractConverter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u001bB\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0002J$\u0010\u0010\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0016J)\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00160\u0018\u00a2\u0006\u0002\b\u001aH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/springframework/cloud/contract/spec/internal/KotlinContractConverter;", "Lorg/springframework/cloud/contract/spec/ContractConverter;", "", "Lorg/springframework/cloud/contract/spec/Contract;", "<init>", "()V", "ext", "", "isAccepted", "", "file", "Ljava/io/File;", "convertFrom", "", "withName", "contracts", "defaultContractName", "counter", "", "convertTo", "contract", "withUpdatedClassloader", "", "block", "Lkotlin/Function1;", "Ljava/lang/ClassLoader;", "Lkotlin/ExtensionFunctionType;", "ScriptWithCurrentClasspathConfiguration", "spring-cloud-contract-spec-kotlin"})
@SourceDebugExtension(value={"SMAP\nKotlinContractConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinContractConverter.kt\norg/springframework/cloud/contract/spec/internal/KotlinContractConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n2756#2:113\n1#3:114\n*S KotlinDebug\n*F\n+ 1 KotlinContractConverter.kt\norg/springframework/cloud/contract/spec/internal/KotlinContractConverter\n*L\n76#1:113\n76#1:114\n*E\n"})
public final class KotlinContractConverter
implements ContractConverter<List<? extends Contract>> {
    @NotNull
    private final String ext;

    public KotlinContractConverter() {
        this.ext = "kts";
        System.setProperty("idea.use.native.fs.for.win", "false");
    }

    public boolean isAccepted(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)this.ext, (Object)FilesKt.getExtension((File)file));
    }

    @NotNull
    public Collection<Contract> convertFrom(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object eval = this.withUpdatedClassloader(file, (Function1<? super ClassLoader, ? extends Object>)((Function1)arg_0 -> KotlinContractConverter.convertFrom$lambda$0(file, arg_0)));
        if (eval instanceof ResultWithDiagnostics.Success) {
            Object object = ((ResultWithDiagnostics.Success)eval).getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.script.experimental.api.EvaluationResult");
            ResultValue resultValue = ((EvaluationResult)object).getReturnValue();
            Intrinsics.checkNotNull((Object)resultValue, (String)"null cannot be cast to non-null type kotlin.script.experimental.api.ResultValue.Value");
            Object parsedValue = ((ResultValue.Value)resultValue).getValue();
            List contracts = parsedValue instanceof Contract ? CollectionsKt.listOf((Object)parsedValue) : (parsedValue instanceof Iterable ? CollectionsKt.filterIsInstance((Iterable)((Iterable)parsedValue), Contract.class) : (parsedValue instanceof Object[] ? ArraysKt.filterIsInstance((Object[])((Object[])parsedValue), Contract.class) : CollectionsKt.emptyList()));
            return this.withName(file, contracts);
        }
        Intrinsics.checkNotNull((Object)eval, (String)"null cannot be cast to non-null type kotlin.script.experimental.api.ResultWithDiagnostics.Failure");
        throw new IllegalStateException("Failed to parse kotlin script due to " + ((ResultWithDiagnostics.Failure)eval).getReports());
    }

    private final Collection<Contract> withName(File file, Collection<? extends Contract> contracts) {
        Iterable iterable;
        AtomicInteger counter = new AtomicInteger(0);
        Iterable $this$onEach$iv = contracts;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u240$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u240$iv) {
            Contract contract = (Contract)element$iv;
            boolean bl2 = false;
            if (ObjectUtils.isEmpty((Object)contract.getName())) {
                contract.setName(this.defaultContractName(file, contracts, counter.get()));
            }
            counter.incrementAndGet();
        }
        return (Collection)iterable;
    }

    private final String defaultContractName(File file, Collection<?> contracts, int counter) {
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        int lastIndexOfDot = StringsKt.lastIndexOf$default((CharSequence)string, (String)".", (int)0, (boolean)false, (int)6, null);
        String string2 = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = string2;
        int n = 0;
        String string4 = string3.substring(n, lastIndexOfDot);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String tillExtension = string4;
        return tillExtension + (String)(counter > 0 || contracts.size() > 1 ? "_" + counter : "");
    }

    @NotNull
    public List<Contract> convertTo(@NotNull Collection<? extends Contract> contract) {
        Intrinsics.checkNotNullParameter(contract, (String)"contract");
        return CollectionsKt.toList((Iterable)contract);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object withUpdatedClassloader(File file, Function1<? super ClassLoader, ? extends Object> block) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object object = new URL[]{file.getParentFile().toURI().toURL()};
            URLClassLoader tempClassLoader = URLClassLoader.newInstance(object, currentClassLoader);
            Thread.currentThread().setContextClassLoader(tempClassLoader);
            Intrinsics.checkNotNull((Object)tempClassLoader);
            object = block.invoke((Object)tempClassLoader);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private static final Object convertFrom$lambda$0(File $file, ClassLoader $this$withUpdatedClassloader) {
        Intrinsics.checkNotNullParameter((Object)$this$withUpdatedClassloader, (String)"$this$withUpdatedClassloader");
        return new BasicJvmScriptingHost(null, null, null, 7, null).eval(ScriptHostUtilKt.toScriptSource((File)$file), (ScriptCompilationConfiguration)new ScriptWithCurrentClasspathConfiguration(), null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/springframework/cloud/contract/spec/internal/KotlinContractConverter$ScriptWithCurrentClasspathConfiguration;", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "<init>", "()V", "spring-cloud-contract-spec-kotlin"})
    public static final class ScriptWithCurrentClasspathConfiguration
    extends ScriptCompilationConfiguration {
        public ScriptWithCurrentClasspathConfiguration() {
            super(ScriptWithCurrentClasspathConfiguration::_init_$lambda$0);
        }

        private static final Unit _init_$lambda$0(ScriptCompilationConfiguration.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"<this>");
            builder.invoke((PropertiesCollection.Builder)JvmScriptCompilationKt.getJvm((ScriptCompilationConfigurationKeys)((ScriptCompilationConfigurationKeys)builder)), ScriptWithCurrentClasspathConfiguration::_init_$lambda$0$0);
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$0$0(JvmScriptCompilationConfigurationBuilder $this$jvm) {
            Intrinsics.checkNotNullParameter((Object)$this$jvm, (String)"$this$jvm");
            JvmScriptCompilationKt.dependenciesFromCurrentContext$default((JvmScriptCompilationConfigurationBuilder)$this$jvm, (String[])new String[0], (boolean)true, (boolean)false, (int)4, null);
            return Unit.INSTANCE;
        }
    }
}

