/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.transport.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.eclipse.aether.repository.AuthenticationContext;

final class DeferredCredentialsProvider
implements CredentialsProvider {
    private final CredentialsProvider delegate = new BasicCredentialsProvider();
    private final ConcurrentHashMap<AuthScope, Factory> factories = new ConcurrentHashMap();

    DeferredCredentialsProvider() {
    }

    public void setCredentials(AuthScope authScope, Factory factory) {
        this.factories.put(authScope, factory);
    }

    @Override
    public void setCredentials(AuthScope authScope, Credentials credentials) {
        this.delegate.setCredentials(authScope, credentials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Credentials getCredentials(AuthScope authScope) {
        ConcurrentHashMap<AuthScope, Factory> concurrentHashMap = this.factories;
        synchronized (concurrentHashMap) {
            Iterator<Map.Entry<AuthScope, Factory>> it = this.factories.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<AuthScope, Factory> entry = it.next();
                if (authScope.match(entry.getKey()) < 0) continue;
                it.remove();
                this.delegate.setCredentials(entry.getKey(), entry.getValue().newCredentials());
            }
        }
        return this.delegate.getCredentials(authScope);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    static interface Factory {
        public Credentials newCredentials();
    }

    static class NtlmFactory
    implements Factory {
        private final AuthenticationContext authContext;

        NtlmFactory(AuthenticationContext authContext) {
            this.authContext = authContext;
        }

        @Override
        public Credentials newCredentials() {
            String username = this.authContext.get("username");
            if (username == null) {
                return null;
            }
            String password = this.authContext.get("password");
            String domain = this.authContext.get("ntlm.domain");
            String workstation = this.authContext.get("ntlm.workstation");
            if (domain == null) {
                int backslash = username.indexOf(92);
                if (backslash < 0) {
                    domain = NtlmFactory.guessDomain();
                } else {
                    domain = username.substring(0, backslash);
                    username = username.substring(backslash + 1);
                }
            }
            if (workstation == null) {
                workstation = NtlmFactory.guessWorkstation();
            }
            return new NTCredentials(username, password, workstation, domain);
        }

        private static String guessDomain() {
            return NtlmFactory.safeNtlmString(System.getProperty("http.auth.ntlm.domain"), System.getenv("USERDOMAIN"));
        }

        private static String guessWorkstation() {
            String localHost = null;
            try {
                localHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            return NtlmFactory.safeNtlmString(System.getProperty("http.auth.ntlm.host"), System.getenv("COMPUTERNAME"), localHost);
        }

        private static String safeNtlmString(String ... strings) {
            for (String string : strings) {
                if (string == null) continue;
                return string;
            }
            return "";
        }
    }

    static class BasicFactory
    implements Factory {
        private final AuthenticationContext authContext;

        BasicFactory(AuthenticationContext authContext) {
            this.authContext = authContext;
        }

        @Override
        public Credentials newCredentials() {
            String username = this.authContext.get("username");
            if (username == null) {
                return null;
            }
            String password = this.authContext.get("password");
            return new UsernamePasswordCredentials(username, password);
        }
    }
}

