/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.inject.spi;

import java.util.List;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.inject.Binder;
import shaded.com.google.inject.Binding;
import shaded.com.google.inject.matcher.Matcher;
import shaded.com.google.inject.spi.Element;
import shaded.com.google.inject.spi.ElementVisitor;
import shaded.com.google.inject.spi.ProvisionListener;

public final class ProvisionListenerBinding
implements Element {
    private final Object source;
    private final Matcher<? super Binding<?>> bindingMatcher;
    private final List<ProvisionListener> listeners;

    ProvisionListenerBinding(Object source, Matcher<? super Binding<?>> bindingMatcher, ProvisionListener[] listeners) {
        this.source = source;
        this.bindingMatcher = bindingMatcher;
        this.listeners = ImmutableList.copyOf(listeners);
    }

    public List<ProvisionListener> getListeners() {
        return this.listeners;
    }

    public Matcher<? super Binding<?>> getBindingMatcher() {
        return this.bindingMatcher;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public <R> R acceptVisitor(ElementVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).bindListener(this.bindingMatcher, this.listeners.toArray(new ProvisionListener[this.listeners.size()]));
    }
}

