/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.BookReturned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Service;

@Service
public class BookService {
    private static final Logger log = LoggerFactory.getLogger(BookService.class);
    @Autowired
    @Qualifier(value="outputChannel")
    private MessageChannel outputChannel;

    public void returnBook(BookReturned bookReturned) {
        log.info("Returning book " + bookReturned);
        this.outputChannel.send(MessageBuilder.withPayload((Object)bookReturned).setHeader("BOOK-NAME", (Object)bookReturned.bookName).build());
    }
}

