/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.plugin;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.springframework.cloud.contract.stubrunner.ContractProjectUpdater;
import org.springframework.cloud.contract.stubrunner.ScmStubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.cloud.contract.verifier.plugin.ContractVerifierExtension;
import org.springframework.cloud.contract.verifier.plugin.StubRunnerOptionsFactory;

public class PublishStubsToScmTask
extends DefaultTask
implements GroovyObject {
    private static final String TASK_NAME = "publishStubsToScm";
    @Nested
    private Config config;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public PublishStubsToScmTask() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @TaskAction
    public void publishStubsToScm() {
        ContractVerifierExtension.ContractRepository repository = this.merged();
        if (!this.shouldRun(repository)) {
            return;
        }
        String projectName = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)DefaultGroovyMethods.toString((Object)((ProjectInternal)this.getProject()).getGroup()), (CharSequence)":"), (CharSequence)((ProjectInternal)this.getProject()).getName().toString()), (CharSequence)":"), (CharSequence)DefaultGroovyMethods.toString((Object)this.getProject().getVersion()));
        ((ProjectInternal)this.getProject()).getLogger().info(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Pushing Stubs to SCM for project [", (CharSequence)projectName), (CharSequence)"]"));
        StubRunnerOptions stubRunnerOptions = StubRunnerOptionsFactory.createStubRunnerOptions(repository, (StubRunnerProperties.StubsMode)ShortTypeHandling.castToEnum((Object)this.config.getContractsMode().getOrElse((Object)StubRunnerProperties.StubsMode.REMOTE), StubRunnerProperties.StubsMode.class), DefaultTypeTransformation.booleanUnbox((Object)this.config.getDeleteStubsAfterTest().get()), (Map)ScriptBytecodeAdapter.castToType((Object)this.config.getContractsProperties().get(), Map.class), DefaultTypeTransformation.booleanUnbox((Object)this.config.getFailOnNoContracts().get()));
        new ContractProjectUpdater(stubRunnerOptions).updateContractProject(projectName, ((Directory)this.config.getStubsOutputDir().get()).getAsFile().toPath());
    }

    public static Config fromExtension(ContractVerifierExtension extension, ObjectFactory objects) {
        return new Config(objects, extension);
    }

    private boolean shouldRun(ContractVerifierExtension.ContractRepository repository) {
        Object object = repository.getRepositoryUrl().getOrNull();
        String string = ShortTypeHandling.castToString((Object)object);
        String contractRepoUrl = DefaultTypeTransformation.booleanUnbox((Object)object) ? string : "";
        if (!DefaultTypeTransformation.booleanUnbox((Object)contractRepoUrl) || !ScmStubDownloaderBuilder.isProtocolAccepted((String)contractRepoUrl)) {
            ((ProjectInternal)this.getProject()).getLogger().warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{contractRepoUrl}, new String[]{"Skipping pushing stubs to scm since your contracts repository URL [", "] doesn't match any of the accepted protocols for SCM stub downloader"})));
            return false;
        }
        return true;
    }

    private ContractVerifierExtension.ContractRepository merged() {
        ContractVerifierExtension.ContractRepository original = (ContractVerifierExtension.ContractRepository)ScriptBytecodeAdapter.castToType((Object)this.config.getContractRepository().get(), ContractVerifierExtension.ContractRepository.class);
        ContractVerifierExtension.ContractRepository stubs = ((ContractVerifierExtension.PublishStubsToScm)this.config.getPublishStubsToScm().get()).getContractRepository();
        ContractVerifierExtension.ContractRepository copied = new ContractVerifierExtension.ContractRepository(this.config.getObjects());
        copied.setRepositoryUrl(ShortTypeHandling.castToString((Object)stubs.getRepositoryUrl().getOrElse(original.getRepositoryUrl().getOrNull())));
        copied.setUsername(ShortTypeHandling.castToString((Object)stubs.getUsername().getOrElse(original.getUsername().getOrNull())));
        copied.setPassword(ShortTypeHandling.castToString((Object)stubs.getPassword().getOrElse(original.getPassword().getOrNull())));
        Integer port = (Integer)ScriptBytecodeAdapter.castToType((Object)stubs.getProxyPort().getOrElse(original.getProxyPort().getOrNull()), Integer.class);
        if (port != null) {
            copied.setProxyPort(port);
        }
        copied.setProxyHost(ShortTypeHandling.castToString((Object)stubs.getProxyHost().getOrElse(original.getProxyHost().getOrNull())));
        return copied;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != PublishStubsToScmTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(PublishStubsToScmTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, PublishStubsToScmTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(PublishStubsToScmTask.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    public static String getTASK_NAME() {
        return TASK_NAME;
    }

    @Generated
    public Config getConfig() {
        return this.config;
    }

    @Generated
    public void setConfig(Config config) {
        this.config = config;
    }

    public static class Config
    implements GroovyObject {
        @Nested
        private final Property<ContractVerifierExtension.ContractRepository> contractRepository;
        @Nested
        private final Property<ContractVerifierExtension.PublishStubsToScm> publishStubsToScm;
        @Input
        private final Property<StubRunnerProperties.StubsMode> contractsMode;
        @Input
        private final Property<Boolean> deleteStubsAfterTest;
        @Input
        private final Property<Boolean> failOnNoContracts;
        @Input
        private final MapProperty<String, String> contractsProperties;
        @OutputDirectory
        private final DirectoryProperty stubsOutputDir;
        @org.gradle.api.tasks.Internal
        private final ObjectFactory objects;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public Config(ObjectFactory objects, ContractVerifierExtension extension) {
            DirectoryProperty directoryProperty;
            MapProperty mapProperty;
            Property property;
            Property property2;
            Property property3;
            Property property4;
            Property property5;
            ObjectFactory objectFactory;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.objects = objectFactory = objects;
            this.contractRepository = property5 = objects.property(ContractVerifierExtension.ContractRepository.class);
            this.contractRepository.set((Object)extension.getContractRepository());
            this.publishStubsToScm = property4 = objects.property(ContractVerifierExtension.PublishStubsToScm.class);
            this.publishStubsToScm.set((Object)extension.getPublishStubsToScm());
            this.contractsMode = property3 = objects.property(StubRunnerProperties.StubsMode.class);
            this.contractsMode.set(extension.getContractsMode());
            this.deleteStubsAfterTest = property2 = objects.property(Boolean.class);
            this.deleteStubsAfterTest.set(extension.getFailOnNoContracts());
            this.failOnNoContracts = property = objects.property(Boolean.class);
            this.failOnNoContracts.set(extension.getDeleteStubsAfterTest());
            this.contractsProperties = mapProperty = objects.mapProperty(String.class, String.class);
            this.contractsProperties.set(extension.getContractsProperties());
            this.stubsOutputDir = directoryProperty = objects.directoryProperty();
            this.stubsOutputDir.set((Provider)extension.getStubsOutputDir());
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Config.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Config.class, PublishStubsToScmTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Config.class, PublishStubsToScmTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PublishStubsToScmTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, PublishStubsToScmTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Config.class, PublishStubsToScmTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Config.class, PublishStubsToScmTask.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public final Property<ContractVerifierExtension.ContractRepository> getContractRepository() {
            return this.contractRepository;
        }

        @Generated
        public final Property<ContractVerifierExtension.PublishStubsToScm> getPublishStubsToScm() {
            return this.publishStubsToScm;
        }

        @Generated
        public final Property<StubRunnerProperties.StubsMode> getContractsMode() {
            return this.contractsMode;
        }

        @Generated
        public final Property<Boolean> getDeleteStubsAfterTest() {
            return this.deleteStubsAfterTest;
        }

        @Generated
        public final Property<Boolean> getFailOnNoContracts() {
            return this.failOnNoContracts;
        }

        @Generated
        public final MapProperty<String, String> getContractsProperties() {
            return this.contractsProperties;
        }

        @Generated
        public final DirectoryProperty getStubsOutputDir() {
            return this.stubsOutputDir;
        }

        @Generated
        public final ObjectFactory getObjects() {
            return this.objects;
        }
    }
}

