/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.util.random;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.EnvironmentPostProcessor;
import org.springframework.boot.SpringApplication;
import org.springframework.cloud.util.random.CachedRandomPropertySource;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

@Configuration(proxyBeanMethods=false)
public class CachedRandomPropertySourceEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final Log logger = LogFactory.getLog(CachedRandomPropertySourceEnvironmentPostProcessor.class);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MutablePropertySources propertySources = environment.getPropertySources();
        PropertySource propertySource = propertySources.get("random");
        if (propertySource != null) {
            PropertySource existing = propertySources.get("cachedrandom");
            if (existing != null) {
                logger.trace((Object)"CachedRandomPropertySource already present");
                return;
            }
            propertySources.addLast((PropertySource)new CachedRandomPropertySource(propertySource));
            logger.trace((Object)"CachedRandomPropertySource added to Environment");
        }
    }

    public int getOrder() {
        return -2147483646;
    }
}

