/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.core.style.ToStringCreator;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="spring.cloud.consul.discovery.heartbeat")
@Validated
public class HeartbeatProperties {
    private static final Log log = LogFactory.getLog(HeartbeatProperties.class);
    boolean enabled = false;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration ttl = Duration.ofSeconds(30L);
    @DecimalMin(value="0.1")
    @DecimalMax(value="0.9")
    private @DecimalMin(value="0.1") @DecimalMax(value="0.9") double intervalRatio = 0.6666666666666666;

    protected Duration computeHeartbeatInterval() {
        double interval = (double)this.ttl.getSeconds() * this.intervalRatio;
        double max = Math.max(interval, 1.0);
        long ttlMinus1 = this.ttl.getSeconds() - 1L;
        double min = Math.min((double)ttlMinus1, max);
        Duration heartbeatInterval = Duration.ofMillis(Math.round(1000.0 * min));
        log.debug((Object)("Computed heartbeatInterval: " + heartbeatInterval));
        return heartbeatInterval;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Duration getTtl() {
        return this.ttl;
    }

    public void setTtl(Duration ttl) {
        this.ttl = ttl;
    }

    @DecimalMin(value="0.1")
    @DecimalMax(value="0.9")
    public @DecimalMin(value="0.1") @DecimalMax(value="0.9") double getIntervalRatio() {
        return this.intervalRatio;
    }

    public void setIntervalRatio(@DecimalMin(value="0.1") @DecimalMax(value="0.9") @DecimalMin(value="0.1") @DecimalMax(value="0.9") double intervalRatio) {
        this.intervalRatio = intervalRatio;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("enabled", this.enabled).append("ttl", (Object)this.ttl).append("intervalRatio", this.intervalRatio).toString();
    }
}

