/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery.reactive;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.catalog.CatalogServicesRequest;
import com.ecwid.consul.v1.health.HealthServicesRequest;
import com.ecwid.consul.v1.health.model.HealthService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.ConsulServerUtils;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class ConsulReactiveDiscoveryClient
implements ReactiveDiscoveryClient {
    private static final Logger logger = LoggerFactory.getLogger(ConsulReactiveDiscoveryClient.class);
    private final ConsulClient client;
    private final ConsulDiscoveryProperties properties;

    public ConsulReactiveDiscoveryClient(ConsulClient client, ConsulDiscoveryProperties properties) {
        this.client = client;
        this.properties = properties;
    }

    public String description() {
        return "Spring Cloud Consul Reactive Discovery Client";
    }

    public Flux<ServiceInstance> getInstances(String serviceId) {
        return Flux.defer(() -> {
            ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
            for (HealthService healthService : this.getHealthServices(serviceId)) {
                instances.add(this.mapToServiceInstance(healthService, serviceId));
            }
            return Flux.fromIterable(instances);
        }).onErrorResume(exception -> {
            logger.error("Error getting instances from Consul.", exception);
            return Flux.empty();
        }).subscribeOn(Schedulers.boundedElastic());
    }

    private List<HealthService> getHealthServices(String serviceId) {
        HealthServicesRequest request = HealthServicesRequest.newBuilder().setTag(this.properties.getDefaultQueryTag()).setPassing(this.properties.isQueryPassing()).setQueryParams(QueryParams.DEFAULT).setToken(this.properties.getAclToken()).build();
        Response services = this.client.getHealthServices(serviceId, request);
        return services == null ? Collections.emptyList() : (List)services.getValue();
    }

    private ServiceInstance mapToServiceInstance(HealthService service, String serviceId) {
        String host = ConsulServerUtils.findHost(service);
        LinkedHashMap metadata = service.getService().getMeta();
        if (metadata == null) {
            metadata = new LinkedHashMap();
        }
        boolean secure = false;
        if (metadata.containsKey("secure")) {
            secure = Boolean.parseBoolean((String)metadata.get("secure"));
        }
        return new DefaultServiceInstance(service.getService().getId(), serviceId, host, service.getService().getPort().intValue(), secure, metadata);
    }

    public Flux<String> getServices() {
        return Flux.defer(() -> {
            CatalogServicesRequest request = CatalogServicesRequest.newBuilder().setToken(this.properties.getAclToken()).setQueryParams(QueryParams.DEFAULT).build();
            Response services = this.client.getCatalogServices(request);
            return services == null ? Flux.empty() : Flux.fromIterable(((Map)services.getValue()).keySet());
        }).onErrorResume(exception -> {
            logger.error("Error getting services from Consul.", exception);
            return Flux.empty();
        }).subscribeOn(Schedulers.boundedElastic());
    }

    public int getOrder() {
        return this.properties.getOrder();
    }
}

