/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.agent.model.NewService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClient;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;

public class TtlScheduler {
    private static final Log log = LogFactory.getLog(ConsulDiscoveryClient.class);
    private final Map<String, ScheduledFuture> serviceHeartbeats = new ConcurrentHashMap<String, ScheduledFuture>();
    private final TaskScheduler scheduler = new ConcurrentTaskScheduler(Executors.newSingleThreadScheduledExecutor());
    private HeartbeatProperties configuration;
    private ConsulClient client;

    public TtlScheduler(HeartbeatProperties configuration, ConsulClient client) {
        this.configuration = configuration;
        this.client = client;
    }

    @Deprecated
    public void add(NewService service) {
        this.add(service.getId());
    }

    public void add(String instanceId) {
        ScheduledFuture task = this.scheduler.scheduleAtFixedRate((Runnable)new ConsulHeartbeatTask(instanceId), this.configuration.computeHeartbeatInterval().toStandardDuration().getMillis());
        ScheduledFuture previousTask = this.serviceHeartbeats.put(instanceId, task);
        if (previousTask != null) {
            previousTask.cancel(true);
        }
    }

    public void remove(String instanceId) {
        ScheduledFuture task = this.serviceHeartbeats.get(instanceId);
        if (task != null) {
            task.cancel(true);
        }
        this.serviceHeartbeats.remove(instanceId);
    }

    private class ConsulHeartbeatTask
    implements Runnable {
        private String checkId;

        ConsulHeartbeatTask(String serviceId) {
            this.checkId = serviceId;
            if (!this.checkId.startsWith("service:")) {
                this.checkId = "service:" + this.checkId;
            }
        }

        @Override
        public void run() {
            TtlScheduler.this.client.agentCheckPass(this.checkId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending consul heartbeat for: " + this.checkId));
            }
        }
    }
}

