/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.health.model.HealthService;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class ConsulServerUtils {
    private static final Log log = LogFactory.getLog(ConsulServerUtils.class);

    public static String findHost(HealthService healthService) {
        HealthService.Service service = healthService.getService();
        HealthService.Node node = healthService.getNode();
        if (StringUtils.hasText((String)service.getAddress())) {
            return service.getAddress();
        }
        if (StringUtils.hasText((String)node.getAddress())) {
            return node.getAddress();
        }
        return node.getNode();
    }

    public static Map<String, String> getMetadata(HealthService healthService) {
        return ConsulServerUtils.getMetadata(healthService.getService().getTags());
    }

    public static Map<String, String> getMetadata(List<String> tags) {
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        if (tags != null) {
            for (String tag : tags) {
                String[] parts = StringUtils.delimitedListToStringArray((String)tag, (String)"=");
                switch (parts.length) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        metadata.put(parts[0], parts[0]);
                        break;
                    }
                    case 2: {
                        metadata.put(parts[0], parts[1]);
                        break;
                    }
                    default: {
                        Object[] end = Arrays.copyOfRange(parts, 1, parts.length);
                        metadata.put(parts[0], StringUtils.arrayToDelimitedString((Object[])end, (String)"="));
                    }
                }
            }
        }
        return metadata;
    }
}

