/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import io.micrometer.core.annotation.Timed;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.consul.ConsulClient;
import org.springframework.cloud.consul.config.ConsulConfigProperties;
import org.springframework.cloud.consul.model.http.ConsulHeaders;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class ConfigWatch
implements ApplicationEventPublisherAware,
SmartLifecycle {
    private static final Log log = LogFactory.getLog(ConfigWatch.class);
    private final ConsulConfigProperties properties;
    private final ConsulClient consul;
    private final TaskScheduler taskScheduler;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private LinkedHashMap<String, Long> consulIndexes;
    private ApplicationEventPublisher publisher;
    private boolean firstTime = true;
    private ScheduledFuture<?> watchFuture;

    public ConfigWatch(ConsulConfigProperties properties, ConsulClient consul, LinkedHashMap<String, Long> initialIndexes) {
        this(properties, consul, initialIndexes, (TaskScheduler)ConfigWatch.getTaskScheduler());
    }

    public ConfigWatch(ConsulConfigProperties properties, ConsulClient consul, LinkedHashMap<String, Long> initialIndexes, TaskScheduler taskScheduler) {
        this.properties = properties;
        this.consul = consul;
        this.consulIndexes = new LinkedHashMap<String, Long>(initialIndexes);
        this.taskScheduler = taskScheduler;
    }

    private static ThreadPoolTaskScheduler getTaskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.initialize();
        return taskScheduler;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.watchFuture = this.taskScheduler.scheduleWithFixedDelay(this::watchConfigKeyValues, (long)this.properties.getWatch().getDelay());
        }
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getPhase() {
        return 0;
    }

    public void stop() {
        if (this.running.compareAndSet(true, false) && this.watchFuture != null) {
            this.watchFuture.cancel(true);
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    /*
     * WARNING - void declaration
     */
    @Timed(value="consul.watch-config-keys")
    public void watchConfigKeyValues() {
        if (!this.running.get()) {
            return;
        }
        for (String string : this.consulIndexes.keySet()) {
            void var2_2;
            if (this.properties.getFormat() != ConsulConfigProperties.Format.FILES && !string.endsWith("/")) {
                String string2 = string + "/";
            }
            try {
                ResponseEntity response;
                String aclToken;
                Long currentIndex = this.consulIndexes.get(var2_2);
                if (currentIndex == null) {
                    currentIndex = -1L;
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("watching consul for context '" + (String)var2_2 + "' with index " + currentIndex));
                }
                if (ObjectUtils.isEmpty((Object)(aclToken = this.properties.getAclToken()))) {
                    aclToken = null;
                }
                if (HttpStatus.OK.isSameCodeAs((response = this.consul.getKVValues((String)var2_2, aclToken, Long.valueOf(this.properties.getWatch().getWaitTime()), currentIndex.longValue())).getStatusCode()) && response.hasBody() && !((List)response.getBody()).isEmpty()) {
                    Long newIndex;
                    String indexHeader = response.getHeaders().getFirst(ConsulHeaders.ConsulIndex.getHeaderName());
                    Long l = newIndex = indexHeader == null ? null : Long.valueOf(Long.parseLong(indexHeader));
                    if (newIndex != null && !newIndex.equals(currentIndex)) {
                        if (!this.consulIndexes.containsValue(newIndex) && !currentIndex.equals(-1L)) {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Context " + (String)var2_2 + " has new index " + newIndex));
                            }
                            RefreshEventData data = new RefreshEventData((String)var2_2, currentIndex, newIndex);
                            this.publisher.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, (Object)data, data.toString()));
                        } else if (log.isTraceEnabled()) {
                            log.trace((Object)("Event for index already published for context " + (String)var2_2));
                        }
                        this.consulIndexes.put((String)var2_2, newIndex);
                        continue;
                    }
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("Same index for context " + (String)var2_2));
                    continue;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("No value for context " + (String)var2_2));
            }
            catch (Exception e) {
                if (this.firstTime && this.properties.isFailFast()) {
                    log.error((Object)"Fail fast is set and there was an error reading configuration from consul.");
                    ReflectionUtils.rethrowRuntimeException((Throwable)e);
                    continue;
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Error querying consul Key/Values for context '" + (String)var2_2 + "'"), (Throwable)e);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Error querying consul Key/Values for context '" + (String)var2_2 + "'. Message: " + e.getMessage()));
            }
        }
        this.firstTime = false;
    }

    public static class RefreshEventData {
        private final String context;
        private final Long prevIndex;
        private final Long newIndex;

        RefreshEventData(String context, Long prevIndex, Long newIndex) {
            this.context = context;
            this.prevIndex = prevIndex;
            this.newIndex = newIndex;
        }

        public String getContext() {
            return this.context;
        }

        public Long getPrevIndex() {
            return this.prevIndex;
        }

        public Long getNewIndex() {
            return this.newIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RefreshEventData that = (RefreshEventData)o;
            return Objects.equals(this.context, that.context) && Objects.equals(this.prevIndex, that.prevIndex) && Objects.equals(this.newIndex, that.newIndex);
        }

        public int hashCode() {
            return Objects.hash(this.context, this.prevIndex, this.newIndex);
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("context", (Object)this.context).append("prevIndex", (Object)this.prevIndex).append("newIndex", (Object)this.newIndex).toString();
        }
    }
}

