/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import com.ecwid.consul.v1.ConsulClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.consul.config.ConsulConfigIndexes;
import org.springframework.cloud.consul.config.ConsulConfigProperties;
import org.springframework.cloud.consul.config.ConsulPropertySource;
import org.springframework.cloud.consul.config.ConsulPropertySources;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.retry.annotation.Retryable;

@Order(value=0)
public class ConsulPropertySourceLocator
implements PropertySourceLocator,
ConsulConfigIndexes {
    private static final Log log = LogFactory.getLog(ConsulPropertySourceLocator.class);
    private final ConsulClient consul;
    private final ConsulConfigProperties properties;
    private final List<String> contexts = new ArrayList<String>();
    private final LinkedHashMap<String, Long> contextIndex = new LinkedHashMap();

    public ConsulPropertySourceLocator(ConsulClient consul, ConsulConfigProperties properties) {
        this.consul = consul;
        this.properties = properties;
    }

    @Deprecated
    public List<String> getContexts() {
        return this.contexts;
    }

    @Override
    public LinkedHashMap<String, Long> getIndexes() {
        return this.contextIndex;
    }

    @Retryable(interceptor="consulRetryInterceptor")
    public Collection<PropertySource<?>> locateCollection(Environment environment) {
        return PropertySourceLocator.locateCollection((PropertySourceLocator)this, (Environment)environment);
    }

    @Retryable(interceptor="consulRetryInterceptor")
    public PropertySource<?> locate(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
            ConsulPropertySources sources = new ConsulPropertySources(this.properties, log);
            List<String> profiles = Arrays.asList(env.getActiveProfiles());
            this.contexts.addAll(sources.getAutomaticContexts(profiles));
            CompositePropertySource composite = new CompositePropertySource("consul");
            for (String propertySourceContext : this.contexts) {
                ConsulPropertySource propertySource = sources.createPropertySource(propertySourceContext, true, this.consul, this.contextIndex::put);
                if (propertySource == null) continue;
                composite.addPropertySource((PropertySource)propertySource);
            }
            return composite;
        }
        return null;
    }

    private void addIndex(String propertySourceContext, Long consulIndex) {
        this.contextIndex.put(propertySourceContext, consulIndex);
    }

    private ConsulPropertySource create(String context) {
        ConsulPropertySource propertySource = new ConsulPropertySource(context, this.consul, this.properties);
        propertySource.init();
        this.addIndex(context, propertySource.getInitialIndex());
        return propertySource;
    }
}

