/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault;

import java.util.concurrent.locks.ReentrantLock;
import org.springframework.util.Assert;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.SessionManager;
import org.springframework.vault.support.VaultToken;

public class StatelessSessionManager
implements SessionManager {
    private final ClientAuthentication clientAuthentication;
    private final ReentrantLock lock = new ReentrantLock();

    public StatelessSessionManager(ClientAuthentication clientAuthentication) {
        Assert.notNull((Object)clientAuthentication, (String)"ClientAuthentication must not be null");
        this.clientAuthentication = clientAuthentication;
    }

    public VaultToken getSessionToken() {
        this.lock.lock();
        try {
            VaultToken vaultToken = this.clientAuthentication.login();
            return vaultToken;
        }
        finally {
            this.lock.unlock();
        }
    }
}

