/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.Pattern;
import org.springframework.cloud.config.server.ssh.SshUriProperties;

public abstract class SshUri {
    private String privateKey;
    private String uri;
    private String hostKeyAlgorithm;
    private String hostKey;
    private String knownHostsFile;
    @Pattern(regexp="([\\w -]+,)*([\\w -]+)")
    private String preferredAuthentications;
    private boolean ignoreLocalSshSettings;
    private boolean strictHostKeyChecking = true;
    private String proxyHost;
    private Integer proxyPort;

    public static SshUriPropertiesBuilder builder() {
        return new SshUriPropertiesBuilder();
    }

    public String getUri() {
        return this.uri;
    }

    public String getHostKeyAlgorithm() {
        return this.hostKeyAlgorithm;
    }

    public String getHostKey() {
        return this.hostKey;
    }

    public String getKnownHostsFile() {
        return this.knownHostsFile;
    }

    public String getPreferredAuthentications() {
        return this.preferredAuthentications;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public boolean isIgnoreLocalSshSettings() {
        return this.ignoreLocalSshSettings;
    }

    public boolean isStrictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setHostKeyAlgorithm(String hostKeyAlgorithm) {
        this.hostKeyAlgorithm = hostKeyAlgorithm;
    }

    public void setHostKey(String hostKey) {
        this.hostKey = hostKey;
    }

    public void setKnownHostsFile(String knownHostsFile) {
        this.knownHostsFile = knownHostsFile;
    }

    public void setPreferredAuthentications(String preferredAuthentications) {
        this.preferredAuthentications = preferredAuthentications;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setIgnoreLocalSshSettings(boolean ignoreLocalSshSettings) {
        this.ignoreLocalSshSettings = ignoreLocalSshSettings;
    }

    public void setStrictHostKeyChecking(boolean strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String toString() {
        return "org.springframework.cloud.config.server.ssh.SshUriProperties(uri=" + this.getUri() + " hostKeyAlgorithm=" + this.getHostKeyAlgorithm() + ", hostKey=" + this.getHostKey() + ", privateKey=" + this.getPrivateKey() + ", ignoreLocalSshSettings=" + this.isIgnoreLocalSshSettings() + ", knownHostsFile=" + this.getKnownHostsFile() + ", preferredAuthentications=" + this.getPreferredAuthentications() + ", strictHostKeyChecking=" + this.isStrictHostKeyChecking() + ", proxyHost=" + this.getProxyHost() + ", proxyPort=" + this.getProxyPort() + ",)";
    }

    public static class SshUriPropertiesBuilder {
        private String uri;
        private String hostKeyAlgorithm;
        private String hostKey;
        private String privateKey;
        private String knownHostsFile;
        private String preferredAuthentications;
        private boolean ignoreLocalSshSettings;
        private boolean strictHostKeyChecking = true;
        private String proxyHost;
        private Integer proxyPort;
        private Map<String, SshUriProperties.SshUriNestedRepoProperties> repos = new LinkedHashMap<String, SshUriProperties.SshUriNestedRepoProperties>();

        SshUriPropertiesBuilder() {
        }

        public SshUriPropertiesBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public SshUriPropertiesBuilder hostKeyAlgorithm(String hostKeyAlgorithm) {
            this.hostKeyAlgorithm = hostKeyAlgorithm;
            return this;
        }

        public SshUriPropertiesBuilder hostKey(String hostKey) {
            this.hostKey = hostKey;
            return this;
        }

        public SshUriPropertiesBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public SshUriPropertiesBuilder knownHostsFile(String knownHostsFile) {
            this.knownHostsFile = knownHostsFile;
            return this;
        }

        public SshUriPropertiesBuilder preferredAuthentications(String preferredAuthentications) {
            this.preferredAuthentications = preferredAuthentications;
            return this;
        }

        public SshUriPropertiesBuilder ignoreLocalSshSettings(boolean ignoreLocalSshSettings) {
            this.ignoreLocalSshSettings = ignoreLocalSshSettings;
            return this;
        }

        public SshUriPropertiesBuilder strictHostKeyChecking(boolean strictHostKeyChecking) {
            this.strictHostKeyChecking = strictHostKeyChecking;
            return this;
        }

        public SshUriPropertiesBuilder proxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public SshUriPropertiesBuilder proxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public SshUriPropertiesBuilder repos(Map<String, SshUriProperties.SshUriNestedRepoProperties> repos) {
            this.repos = repos;
            return this;
        }

        public SshUriProperties build() {
            SshUriProperties sshUriProperties = new SshUriProperties();
            sshUriProperties.setRepos(this.repos);
            this.build(sshUriProperties);
            return sshUriProperties;
        }

        public SshUriProperties.SshUriNestedRepoProperties buildAsNestedRepo() {
            SshUriProperties.SshUriNestedRepoProperties sshUriNestedRepoProperties = new SshUriProperties.SshUriNestedRepoProperties();
            this.build(sshUriNestedRepoProperties);
            return sshUriNestedRepoProperties;
        }

        private void build(SshUri sshUriNestedRepoProperties) {
            sshUriNestedRepoProperties.setUri(this.uri);
            sshUriNestedRepoProperties.setHostKeyAlgorithm(this.hostKeyAlgorithm);
            sshUriNestedRepoProperties.setHostKey(this.hostKey);
            sshUriNestedRepoProperties.setPrivateKey(this.privateKey);
            sshUriNestedRepoProperties.setKnownHostsFile(this.knownHostsFile);
            sshUriNestedRepoProperties.setPreferredAuthentications(this.preferredAuthentications);
            sshUriNestedRepoProperties.setIgnoreLocalSshSettings(this.ignoreLocalSshSettings);
            sshUriNestedRepoProperties.setStrictHostKeyChecking(this.strictHostKeyChecking);
            sshUriNestedRepoProperties.setProxyHost(this.proxyHost);
            sshUriNestedRepoProperties.setProxyPort(this.proxyPort);
        }

        public String toString() {
            return "org.springframework.cloud.config.server.ssh.SshUriProperties.SshUriPropertiesBuilder(uri=" + this.uri + "hostKeyAlgorithm=" + this.hostKeyAlgorithm + ", hostKey=" + this.hostKey + ", privateKey=" + this.privateKey + ", knownHostsFile=" + this.knownHostsFile + ", preferredAuthentications=" + this.preferredAuthentications + ", ignoreLocalSshSettings=" + this.ignoreLocalSshSettings + ", strictHostKeyChecking=" + this.strictHostKeyChecking + ", proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", repos=" + this.repos + ")";
        }
    }
}

