/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.environment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.config.environment.PropertySource;

public class Environment {
    private String name;
    private String[] profiles = new String[0];
    private String label;
    private List<PropertySource> propertySources = new ArrayList<PropertySource>();

    public Environment(String name, String ... profiles) {
        this(name, profiles, "master");
    }

    @JsonCreator
    public Environment(@JsonProperty(value="name") String name, @JsonProperty(value="profiles") String[] profiles, @JsonProperty(value="label") String label) {
        this.name = name;
        this.profiles = profiles;
        this.label = label;
    }

    public void add(PropertySource propertySource) {
        this.propertySources.add(propertySource);
    }

    public void addFirst(PropertySource propertySource) {
        this.propertySources.add(0, propertySource);
    }

    public List<PropertySource> getPropertySources() {
        return this.propertySources;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String[] getProfiles() {
        return this.profiles;
    }

    public void setProfiles(String[] profiles) {
        this.profiles = profiles;
    }

    public String toString() {
        return "Environment [name=" + this.name + ", profiles=" + Arrays.asList(this.profiles) + ", label=" + this.label + ", propertySources=" + this.propertySources + "]";
    }
}

