/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.health;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.health.contributor.CompositeHealthContributor;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.boot.health.contributor.HealthContributors;
import org.springframework.boot.health.contributor.HealthIndicator;
import org.springframework.cloud.client.discovery.health.DiscoveryHealthIndicator;
import org.springframework.util.Assert;

public class DiscoveryCompositeHealthContributor
implements CompositeHealthContributor {
    private Map<String, DiscoveryHealthIndicator> indicators;

    public DiscoveryCompositeHealthContributor(Collection<DiscoveryHealthIndicator> indicators) {
        Assert.notNull(indicators, (String)"'indicators' must not be null");
        this.indicators = indicators.stream().collect(Collectors.toMap(DiscoveryHealthIndicator::getName, Function.identity()));
    }

    public Stream<HealthContributors.Entry> stream() {
        return this.indicators.entrySet().stream().map(entry -> new HealthContributors.Entry((String)entry.getKey(), (HealthContributor)this.asHealthIndicator((DiscoveryHealthIndicator)entry.getValue())));
    }

    public HealthContributor getContributor(String name) {
        return this.asHealthIndicator(this.indicators.get(name));
    }

    private HealthIndicator asHealthIndicator(DiscoveryHealthIndicator indicator) {
        return indicator != null ? indicator::health : null;
    }

    public Map<String, DiscoveryHealthIndicator> getIndicators() {
        return Collections.unmodifiableMap(this.indicators);
    }
}

