/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.simple;

import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.noop.NoopDiscoveryClientAutoConfiguration;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClient;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.util.ClassUtils;

@Configuration
@AutoConfigureBefore(value={NoopDiscoveryClientAutoConfiguration.class})
public class SimpleDiscoveryClientAutoConfiguration {
    @Autowired(required=false)
    private ServerProperties server;
    @Autowired
    private ApplicationContext context;
    @Value(value="${spring.application.name:application}")
    private String serviceId;
    @Autowired
    private InetUtils inet;

    @Bean
    public SimpleDiscoveryProperties simpleDiscoveryProperties() {
        SimpleDiscoveryProperties simple = new SimpleDiscoveryProperties();
        simple.getLocal().setServiceId(this.serviceId);
        simple.getLocal().setUri(URI.create("http://" + this.inet.findFirstNonLoopbackHostInfo().getHostname() + ":" + this.findPort()));
        return simple;
    }

    @Bean
    @Order(value=0x7FFFFFFF)
    public DiscoveryClient simpleDiscoveryClient() {
        return new SimpleDiscoveryClient(this.simpleDiscoveryProperties());
    }

    private int findPort() {
        EmbeddedServletContainer container;
        if (ClassUtils.isPresent((String)"org.springframework.boot.context.embedded.EmbeddedWebApplicationContext", null) && this.context instanceof EmbeddedWebApplicationContext && (container = ((EmbeddedWebApplicationContext)this.context).getEmbeddedServletContainer()) != null) {
            return container.getPort();
        }
        if (this.server != null && this.server.getPort() != null && this.server.getPort() > 0) {
            return this.server.getPort();
        }
        return 8080;
    }
}

